// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clb

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opTagNLBResourcesCommon = "TagNLBResources"

// TagNLBResourcesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the TagNLBResourcesCommon operation. The "output" return
// value will be populated with the TagNLBResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned TagNLBResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after TagNLBResourcesCommon Send returns without error.
//
// See TagNLBResourcesCommon for more information on using the TagNLBResourcesCommon
// API call, and error handling.
//
//    // Example sending a request using the TagNLBResourcesCommonRequest method.
//    req, resp := client.TagNLBResourcesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) TagNLBResourcesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opTagNLBResourcesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// TagNLBResourcesCommon API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation TagNLBResourcesCommon for usage and error information.
func (c *CLB) TagNLBResourcesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.TagNLBResourcesCommonRequest(input)
	return out, req.Send()
}

// TagNLBResourcesCommonWithContext is the same as TagNLBResourcesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See TagNLBResourcesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) TagNLBResourcesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.TagNLBResourcesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagNLBResources = "TagNLBResources"

// TagNLBResourcesRequest generates a "volcengine/request.Request" representing the
// client's request for the TagNLBResources operation. The "output" return
// value will be populated with the TagNLBResourcesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned TagNLBResourcesCommon Request to send the API call to the service.
// the "output" return value is not valid until after TagNLBResourcesCommon Send returns without error.
//
// See TagNLBResources for more information on using the TagNLBResources
// API call, and error handling.
//
//    // Example sending a request using the TagNLBResourcesRequest method.
//    req, resp := client.TagNLBResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLB) TagNLBResourcesRequest(input *TagNLBResourcesInput) (req *request.Request, output *TagNLBResourcesOutput) {
	op := &request.Operation{
		Name:       opTagNLBResources,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagNLBResourcesInput{}
	}

	output = &TagNLBResourcesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// TagNLBResources API operation for CLB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLB's
// API operation TagNLBResources for usage and error information.
func (c *CLB) TagNLBResources(input *TagNLBResourcesInput) (*TagNLBResourcesOutput, error) {
	req, out := c.TagNLBResourcesRequest(input)
	return out, req.Send()
}

// TagNLBResourcesWithContext is the same as TagNLBResources with the addition of
// the ability to pass a context and additional request options.
//
// See TagNLBResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLB) TagNLBResourcesWithContext(ctx volcengine.Context, input *TagNLBResourcesInput, opts ...request.Option) (*TagNLBResourcesOutput, error) {
	req, out := c.TagNLBResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type TagForTagNLBResourcesInput struct {
	_ struct{} `type:"structure"`

	// Key is a required field
	Key *string `type:"string" required:"true"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForTagNLBResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForTagNLBResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagForTagNLBResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagForTagNLBResourcesInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagForTagNLBResourcesInput) SetKey(v string) *TagForTagNLBResourcesInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForTagNLBResourcesInput) SetValue(v string) *TagForTagNLBResourcesInput {
	s.Value = &v
	return s
}

type TagNLBResourcesInput struct {
	_ struct{} `type:"structure"`

	// ResourceIds is a required field
	ResourceIds []*string `type:"list" required:"true"`

	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"ResourceTypeForTagNLBResourcesInput"`

	Tags []*TagForTagNLBResourcesInput `type:"list"`
}

// String returns the string representation
func (s TagNLBResourcesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagNLBResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagNLBResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagNLBResourcesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *TagNLBResourcesInput) SetResourceIds(v []*string) *TagNLBResourcesInput {
	s.ResourceIds = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *TagNLBResourcesInput) SetResourceType(v string) *TagNLBResourcesInput {
	s.ResourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagNLBResourcesInput) SetTags(v []*TagForTagNLBResourcesInput) *TagNLBResourcesInput {
	s.Tags = v
	return s
}

type TagNLBResourcesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s TagNLBResourcesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagNLBResourcesOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *TagNLBResourcesOutput) SetRequestId(v string) *TagNLBResourcesOutput {
	s.RequestId = &v
	return s
}

const (
	// ResourceTypeForTagNLBResourcesInputNlb is a ResourceTypeForTagNLBResourcesInput enum value
	ResourceTypeForTagNLBResourcesInputNlb = "nlb"

	// ResourceTypeForTagNLBResourcesInputNlbListener is a ResourceTypeForTagNLBResourcesInput enum value
	ResourceTypeForTagNLBResourcesInputNlbListener = "nlb_listener"

	// ResourceTypeForTagNLBResourcesInputNlbServergroup is a ResourceTypeForTagNLBResourcesInput enum value
	ResourceTypeForTagNLBResourcesInputNlbServergroup = "nlb_servergroup"

	// ResourceTypeForTagNLBResourcesInputNlbSecurityPolicy is a ResourceTypeForTagNLBResourcesInput enum value
	ResourceTypeForTagNLBResourcesInputNlbSecurityPolicy = "nlb_security_policy"
)
