package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDpiConfigError invokes the smartag.ListDpiConfigError API synchronously
func (client *Client) ListDpiConfigError(request *ListDpiConfigErrorRequest) (response *ListDpiConfigErrorResponse, err error) {
	response = CreateListDpiConfigErrorResponse()
	err = client.DoAction(request, response)
	return
}

// ListDpiConfigErrorWithChan invokes the smartag.ListDpiConfigError API asynchronously
func (client *Client) ListDpiConfigErrorWithChan(request *ListDpiConfigErrorRequest) (<-chan *ListDpiConfigErrorResponse, <-chan error) {
	responseChan := make(chan *ListDpiConfigErrorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDpiConfigError(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDpiConfigErrorWithCallback invokes the smartag.ListDpiConfigError API asynchronously
func (client *Client) ListDpiConfigErrorWithCallback(request *ListDpiConfigErrorRequest, callback func(response *ListDpiConfigErrorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDpiConfigErrorResponse
		var err error
		defer close(result)
		response, err = client.ListDpiConfigError(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDpiConfigErrorRequest is the request struct for api ListDpiConfigError
type ListDpiConfigErrorRequest struct {
	*requests.RpcRequest
	DpiConfigType  string           `position:"Query" name:"DpiConfigType"`
	NextToken      string           `position:"Query" name:"NextToken"`
	SmartAGId      string           `position:"Query" name:"SmartAGId"`
	RuleInstanceId string           `position:"Query" name:"RuleInstanceId"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
}

// ListDpiConfigErrorResponse is the response struct for api ListDpiConfigError
type ListDpiConfigErrorResponse struct {
	*responses.BaseResponse
	NextToken      string               `json:"NextToken" xml:"NextToken"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Total          int                  `json:"Total" xml:"Total"`
	MaxResults     int                  `json:"MaxResults" xml:"MaxResults"`
	DpiConfigError []DpiConfigErrorItem `json:"DpiConfigError" xml:"DpiConfigError"`
}

// CreateListDpiConfigErrorRequest creates a request to invoke ListDpiConfigError API
func CreateListDpiConfigErrorRequest() (request *ListDpiConfigErrorRequest) {
	request = &ListDpiConfigErrorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ListDpiConfigError", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDpiConfigErrorResponse creates a response to parse from ListDpiConfigError response
func CreateListDpiConfigErrorResponse() (response *ListDpiConfigErrorResponse) {
	response = &ListDpiConfigErrorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
