package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyElasticRule invokes the selectdb.ModifyElasticRule API synchronously
func (client *Client) ModifyElasticRule(request *ModifyElasticRuleRequest) (response *ModifyElasticRuleResponse, err error) {
	response = CreateModifyElasticRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyElasticRuleWithChan invokes the selectdb.ModifyElasticRule API asynchronously
func (client *Client) ModifyElasticRuleWithChan(request *ModifyElasticRuleRequest) (<-chan *ModifyElasticRuleResponse, <-chan error) {
	responseChan := make(chan *ModifyElasticRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyElasticRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyElasticRuleWithCallback invokes the selectdb.ModifyElasticRule API asynchronously
func (client *Client) ModifyElasticRuleWithCallback(request *ModifyElasticRuleRequest, callback func(response *ModifyElasticRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyElasticRuleResponse
		var err error
		defer close(result)
		response, err = client.ModifyElasticRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyElasticRuleRequest is the request struct for api ModifyElasticRule
type ModifyElasticRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbInstanceId         string           `position:"Query" name:"DbInstanceId"`
	Product              string           `position:"Query" name:"Product"`
	ExecutionPeriod      string           `position:"Query" name:"ExecutionPeriod"`
	ClusterId            string           `position:"Query" name:"ClusterId"`
	ElasticRuleStartTime string           `position:"Query" name:"ElasticRuleStartTime"`
	ClusterClass         string           `position:"Query" name:"ClusterClass"`
	RuleId               requests.Integer `position:"Query" name:"RuleId"`
}

// ModifyElasticRuleResponse is the response struct for api ModifyElasticRule
type ModifyElasticRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyElasticRuleRequest creates a request to invoke ModifyElasticRule API
func CreateModifyElasticRuleRequest() (request *ModifyElasticRuleRequest) {
	request = &ModifyElasticRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "ModifyElasticRule", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyElasticRuleResponse creates a response to parse from ModifyElasticRule response
func CreateModifyElasticRuleResponse() (response *ModifyElasticRuleResponse) {
	response = &ModifyElasticRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
