package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResourceShare invokes the resourcesharing.UpdateResourceShare API synchronously
func (client *Client) UpdateResourceShare(request *UpdateResourceShareRequest) (response *UpdateResourceShareResponse, err error) {
	response = CreateUpdateResourceShareResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResourceShareWithChan invokes the resourcesharing.UpdateResourceShare API asynchronously
func (client *Client) UpdateResourceShareWithChan(request *UpdateResourceShareRequest) (<-chan *UpdateResourceShareResponse, <-chan error) {
	responseChan := make(chan *UpdateResourceShareResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResourceShare(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResourceShareWithCallback invokes the resourcesharing.UpdateResourceShare API asynchronously
func (client *Client) UpdateResourceShareWithCallback(request *UpdateResourceShareRequest, callback func(response *UpdateResourceShareResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResourceShareResponse
		var err error
		defer close(result)
		response, err = client.UpdateResourceShare(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResourceShareRequest is the request struct for api UpdateResourceShare
type UpdateResourceShareRequest struct {
	*requests.RpcRequest
	ResourceShareName    string           `position:"Query" name:"ResourceShareName"`
	ResourceShareId      string           `position:"Query" name:"ResourceShareId"`
	AllowExternalTargets requests.Boolean `position:"Query" name:"AllowExternalTargets"`
}

// UpdateResourceShareResponse is the response struct for api UpdateResourceShare
type UpdateResourceShareResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	ResourceShare ResourceShare `json:"ResourceShare" xml:"ResourceShare"`
}

// CreateUpdateResourceShareRequest creates a request to invoke UpdateResourceShare API
func CreateUpdateResourceShareRequest() (request *UpdateResourceShareRequest) {
	request = &UpdateResourceShareRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "UpdateResourceShare", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateResourceShareResponse creates a response to parse from UpdateResourceShare response
func CreateUpdateResourceShareResponse() (response *UpdateResourceShareResponse) {
	response = &UpdateResourceShareResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
