package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSQLLogFiles invokes the rds.DescribeSQLLogFiles API synchronously
func (client *Client) DescribeSQLLogFiles(request *DescribeSQLLogFilesRequest) (response *DescribeSQLLogFilesResponse, err error) {
	response = CreateDescribeSQLLogFilesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSQLLogFilesWithChan invokes the rds.DescribeSQLLogFiles API asynchronously
func (client *Client) DescribeSQLLogFilesWithChan(request *DescribeSQLLogFilesRequest) (<-chan *DescribeSQLLogFilesResponse, <-chan error) {
	responseChan := make(chan *DescribeSQLLogFilesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSQLLogFiles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSQLLogFilesWithCallback invokes the rds.DescribeSQLLogFiles API asynchronously
func (client *Client) DescribeSQLLogFilesWithCallback(request *DescribeSQLLogFilesRequest, callback func(response *DescribeSQLLogFilesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSQLLogFilesResponse
		var err error
		defer close(result)
		response, err = client.DescribeSQLLogFiles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSQLLogFilesRequest is the request struct for api DescribeSQLLogFiles
type DescribeSQLLogFilesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	FileName             string           `position:"Query" name:"FileName"`
}

// DescribeSQLLogFilesResponse is the response struct for api DescribeSQLLogFiles
type DescribeSQLLogFilesResponse struct {
	*responses.BaseResponse
	RequestId        string                     `json:"RequestId" xml:"RequestId"`
	PageNumber       int                        `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int                        `json:"PageRecordCount" xml:"PageRecordCount"`
	TotalRecordCount int                        `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Items            ItemsInDescribeSQLLogFiles `json:"Items" xml:"Items"`
}

// CreateDescribeSQLLogFilesRequest creates a request to invoke DescribeSQLLogFiles API
func CreateDescribeSQLLogFilesRequest() (request *DescribeSQLLogFilesRequest) {
	request = &DescribeSQLLogFilesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeSQLLogFiles", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSQLLogFilesResponse creates a response to parse from DescribeSQLLogFiles response
func CreateDescribeSQLLogFilesResponse() (response *DescribeSQLLogFilesResponse) {
	response = &DescribeSQLLogFilesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
