package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindZoneVpc invokes the pvtz.BindZoneVpc API synchronously
func (client *Client) BindZoneVpc(request *BindZoneVpcRequest) (response *BindZoneVpcResponse, err error) {
	response = CreateBindZoneVpcResponse()
	err = client.DoAction(request, response)
	return
}

// BindZoneVpcWithChan invokes the pvtz.BindZoneVpc API asynchronously
func (client *Client) BindZoneVpcWithChan(request *BindZoneVpcRequest) (<-chan *BindZoneVpcResponse, <-chan error) {
	responseChan := make(chan *BindZoneVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindZoneVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindZoneVpcWithCallback invokes the pvtz.BindZoneVpc API asynchronously
func (client *Client) BindZoneVpcWithCallback(request *BindZoneVpcRequest, callback func(response *BindZoneVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindZoneVpcResponse
		var err error
		defer close(result)
		response, err = client.BindZoneVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindZoneVpcRequest is the request struct for api BindZoneVpc
type BindZoneVpcRequest struct {
	*requests.RpcRequest
	Dryrun       requests.Boolean   `position:"Query" name:"Dryrun"`
	ClientToken  string             `position:"Query" name:"ClientToken"`
	UserClientIp string             `position:"Query" name:"UserClientIp"`
	ZoneId       string             `position:"Query" name:"ZoneId"`
	Lang         string             `position:"Query" name:"Lang"`
	Vpcs         *[]BindZoneVpcVpcs `position:"Query" name:"Vpcs"  type:"Repeated"`
	RemoteType   string             `position:"Query" name:"RemoteType"`
}

// BindZoneVpcVpcs is a repeated param struct in BindZoneVpcRequest
type BindZoneVpcVpcs struct {
	VpcType  string `name:"VpcType"`
	RegionId string `name:"RegionId"`
	VpcId    string `name:"VpcId"`
}

// BindZoneVpcResponse is the response struct for api BindZoneVpc
type BindZoneVpcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindZoneVpcRequest creates a request to invoke BindZoneVpc API
func CreateBindZoneVpcRequest() (request *BindZoneVpcRequest) {
	request = &BindZoneVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "BindZoneVpc", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindZoneVpcResponse creates a response to parse from BindZoneVpc response
func CreateBindZoneVpcResponse() (response *BindZoneVpcResponse) {
	response = &BindZoneVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
