package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePolarDBXInstanceNode invokes the polardbx.UpdatePolarDBXInstanceNode API synchronously
func (client *Client) UpdatePolarDBXInstanceNode(request *UpdatePolarDBXInstanceNodeRequest) (response *UpdatePolarDBXInstanceNodeResponse, err error) {
	response = CreateUpdatePolarDBXInstanceNodeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePolarDBXInstanceNodeWithChan invokes the polardbx.UpdatePolarDBXInstanceNode API asynchronously
func (client *Client) UpdatePolarDBXInstanceNodeWithChan(request *UpdatePolarDBXInstanceNodeRequest) (<-chan *UpdatePolarDBXInstanceNodeResponse, <-chan error) {
	responseChan := make(chan *UpdatePolarDBXInstanceNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePolarDBXInstanceNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePolarDBXInstanceNodeWithCallback invokes the polardbx.UpdatePolarDBXInstanceNode API asynchronously
func (client *Client) UpdatePolarDBXInstanceNodeWithCallback(request *UpdatePolarDBXInstanceNodeRequest, callback func(response *UpdatePolarDBXInstanceNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePolarDBXInstanceNodeResponse
		var err error
		defer close(result)
		response, err = client.UpdatePolarDBXInstanceNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePolarDBXInstanceNodeRequest is the request struct for api UpdatePolarDBXInstanceNode
type UpdatePolarDBXInstanceNodeRequest struct {
	*requests.RpcRequest
	AddDNSpec           string `position:"Query" name:"AddDNSpec"`
	StoragePoolName     string `position:"Query" name:"StoragePoolName"`
	DbInstanceNodeCount string `position:"Query" name:"DbInstanceNodeCount"`
	CNNodeCount         string `position:"Query" name:"CNNodeCount"`
	DBInstanceName      string `position:"Query" name:"DBInstanceName"`
	ClientToken         string `position:"Query" name:"ClientToken"`
	DeleteDNIds         string `position:"Query" name:"DeleteDNIds"`
	DNNodeCount         string `position:"Query" name:"DNNodeCount"`
}

// UpdatePolarDBXInstanceNodeResponse is the response struct for api UpdatePolarDBXInstanceNode
type UpdatePolarDBXInstanceNodeResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdatePolarDBXInstanceNodeRequest creates a request to invoke UpdatePolarDBXInstanceNode API
func CreateUpdatePolarDBXInstanceNodeRequest() (request *UpdatePolarDBXInstanceNodeRequest) {
	request = &UpdatePolarDBXInstanceNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "UpdatePolarDBXInstanceNode", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdatePolarDBXInstanceNodeResponse creates a response to parse from UpdatePolarDBXInstanceNode response
func CreateUpdatePolarDBXInstanceNodeResponse() (response *UpdatePolarDBXInstanceNodeResponse) {
	response = &UpdatePolarDBXInstanceNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
