package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLicenseOrders invokes the polardb.DescribeLicenseOrders API synchronously
func (client *Client) DescribeLicenseOrders(request *DescribeLicenseOrdersRequest) (response *DescribeLicenseOrdersResponse, err error) {
	response = CreateDescribeLicenseOrdersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLicenseOrdersWithChan invokes the polardb.DescribeLicenseOrders API asynchronously
func (client *Client) DescribeLicenseOrdersWithChan(request *DescribeLicenseOrdersRequest) (<-chan *DescribeLicenseOrdersResponse, <-chan error) {
	responseChan := make(chan *DescribeLicenseOrdersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLicenseOrders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLicenseOrdersWithCallback invokes the polardb.DescribeLicenseOrders API asynchronously
func (client *Client) DescribeLicenseOrdersWithCallback(request *DescribeLicenseOrdersRequest, callback func(response *DescribeLicenseOrdersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLicenseOrdersResponse
		var err error
		defer close(result)
		response, err = client.DescribeLicenseOrders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLicenseOrdersRequest is the request struct for api DescribeLicenseOrders
type DescribeLicenseOrdersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	VirtualOrder         requests.Boolean `position:"Query" name:"VirtualOrder"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	AliyunOrderId        string           `position:"Query" name:"AliyunOrderId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PurchaseChannel      string           `position:"Query" name:"PurchaseChannel"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PackageType          string           `position:"Query" name:"PackageType"`
}

// DescribeLicenseOrdersResponse is the response struct for api DescribeLicenseOrders
type DescribeLicenseOrdersResponse struct {
	*responses.BaseResponse
	PageNumber       int            `json:"PageNumber" xml:"PageNumber"`
	PageRecordCount  int            `json:"PageRecordCount" xml:"PageRecordCount"`
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	TotalRecordCount int            `json:"TotalRecordCount" xml:"TotalRecordCount"`
	Items            []LicenseOrder `json:"Items" xml:"Items"`
}

// CreateDescribeLicenseOrdersRequest creates a request to invoke DescribeLicenseOrders API
func CreateDescribeLicenseOrdersRequest() (request *DescribeLicenseOrdersRequest) {
	request = &DescribeLicenseOrdersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeLicenseOrders", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLicenseOrdersResponse creates a response to parse from DescribeLicenseOrders response
func CreateDescribeLicenseOrdersResponse() (response *DescribeLicenseOrdersResponse) {
	response = &DescribeLicenseOrdersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
