package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckKMSAuthorized invokes the polardb.CheckKMSAuthorized API synchronously
func (client *Client) CheckKMSAuthorized(request *CheckKMSAuthorizedRequest) (response *CheckKMSAuthorizedResponse, err error) {
	response = CreateCheckKMSAuthorizedResponse()
	err = client.DoAction(request, response)
	return
}

// CheckKMSAuthorizedWithChan invokes the polardb.CheckKMSAuthorized API asynchronously
func (client *Client) CheckKMSAuthorizedWithChan(request *CheckKMSAuthorizedRequest) (<-chan *CheckKMSAuthorizedResponse, <-chan error) {
	responseChan := make(chan *CheckKMSAuthorizedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckKMSAuthorized(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckKMSAuthorizedWithCallback invokes the polardb.CheckKMSAuthorized API asynchronously
func (client *Client) CheckKMSAuthorizedWithCallback(request *CheckKMSAuthorizedRequest, callback func(response *CheckKMSAuthorizedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckKMSAuthorizedResponse
		var err error
		defer close(result)
		response, err = client.CheckKMSAuthorized(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckKMSAuthorizedRequest is the request struct for api CheckKMSAuthorized
type CheckKMSAuthorizedRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TDERegion            string           `position:"Query" name:"TDERegion"`
}

// CheckKMSAuthorizedResponse is the response struct for api CheckKMSAuthorized
type CheckKMSAuthorizedResponse struct {
	*responses.BaseResponse
	AuthorizationState int    `json:"AuthorizationState" xml:"AuthorizationState"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	RoleArn            string `json:"RoleArn" xml:"RoleArn"`
	DBClusterId        string `json:"DBClusterId" xml:"DBClusterId"`
}

// CreateCheckKMSAuthorizedRequest creates a request to invoke CheckKMSAuthorized API
func CreateCheckKMSAuthorizedRequest() (request *CheckKMSAuthorizedRequest) {
	request = &CheckKMSAuthorizedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CheckKMSAuthorized", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckKMSAuthorizedResponse creates a response to parse from CheckKMSAuthorized response
func CreateCheckKMSAuthorizedResponse() (response *CheckKMSAuthorizedResponse) {
	response = &CheckKMSAuthorizedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
