package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceRuleItem invokes the pairecservice.DeleteResourceRuleItem API synchronously
func (client *Client) DeleteResourceRuleItem(request *DeleteResourceRuleItemRequest) (response *DeleteResourceRuleItemResponse, err error) {
	response = CreateDeleteResourceRuleItemResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceRuleItemWithChan invokes the pairecservice.DeleteResourceRuleItem API asynchronously
func (client *Client) DeleteResourceRuleItemWithChan(request *DeleteResourceRuleItemRequest) (<-chan *DeleteResourceRuleItemResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceRuleItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceRuleItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceRuleItemWithCallback invokes the pairecservice.DeleteResourceRuleItem API asynchronously
func (client *Client) DeleteResourceRuleItemWithCallback(request *DeleteResourceRuleItemRequest, callback func(response *DeleteResourceRuleItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceRuleItemResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceRuleItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceRuleItemRequest is the request struct for api DeleteResourceRuleItem
type DeleteResourceRuleItemRequest struct {
	*requests.RoaRequest
	ResourceRuleId     string `position:"Path" name:"ResourceRuleId"`
	ResourceRuleItemId string `position:"Path" name:"ResourceRuleItemId"`
	InstanceId         string `position:"Query" name:"InstanceId"`
}

// DeleteResourceRuleItemResponse is the response struct for api DeleteResourceRuleItem
type DeleteResourceRuleItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourceRuleItemRequest creates a request to invoke DeleteResourceRuleItem API
func CreateDeleteResourceRuleItemRequest() (request *DeleteResourceRuleItemRequest) {
	request = &DeleteResourceRuleItemRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteResourceRuleItem", "/api/v1/resourcerules/[ResourceRuleId]/items/[ResourceRuleItemId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteResourceRuleItemResponse creates a response to parse from DeleteResourceRuleItem response
func CreateDeleteResourceRuleItemResponse() (response *DeleteResourceRuleItemResponse) {
	response = &DeleteResourceRuleItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
