package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceRuleItem invokes the pairecservice.CreateResourceRuleItem API synchronously
func (client *Client) CreateResourceRuleItem(request *CreateResourceRuleItemRequest) (response *CreateResourceRuleItemResponse, err error) {
	response = CreateCreateResourceRuleItemResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceRuleItemWithChan invokes the pairecservice.CreateResourceRuleItem API asynchronously
func (client *Client) CreateResourceRuleItemWithChan(request *CreateResourceRuleItemRequest) (<-chan *CreateResourceRuleItemResponse, <-chan error) {
	responseChan := make(chan *CreateResourceRuleItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceRuleItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceRuleItemWithCallback invokes the pairecservice.CreateResourceRuleItem API asynchronously
func (client *Client) CreateResourceRuleItemWithCallback(request *CreateResourceRuleItemRequest, callback func(response *CreateResourceRuleItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceRuleItemResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceRuleItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceRuleItemRequest is the request struct for api CreateResourceRuleItem
type CreateResourceRuleItemRequest struct {
	*requests.RoaRequest
	Body           string `position:"Body" name:"body"`
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
}

// CreateResourceRuleItemResponse is the response struct for api CreateResourceRuleItem
type CreateResourceRuleItemResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ResourceRuleItemId string `json:"ResourceRuleItemId" xml:"ResourceRuleItemId"`
}

// CreateCreateResourceRuleItemRequest creates a request to invoke CreateResourceRuleItem API
func CreateCreateResourceRuleItemRequest() (request *CreateResourceRuleItemRequest) {
	request = &CreateResourceRuleItemRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateResourceRuleItem", "/api/v1/resourcerules/[ResourceRuleId]/items", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateResourceRuleItemResponse creates a response to parse from CreateResourceRuleItem response
func CreateCreateResourceRuleItemResponse() (response *CreateResourceRuleItemResponse) {
	response = &CreateResourceRuleItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
