package paielasticdatasetaccelerator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEndpoint invokes the paielasticdatasetaccelerator.DescribeEndpoint API synchronously
func (client *Client) DescribeEndpoint(request *DescribeEndpointRequest) (response *DescribeEndpointResponse, err error) {
	response = CreateDescribeEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEndpointWithChan invokes the paielasticdatasetaccelerator.DescribeEndpoint API asynchronously
func (client *Client) DescribeEndpointWithChan(request *DescribeEndpointRequest) (<-chan *DescribeEndpointResponse, <-chan error) {
	responseChan := make(chan *DescribeEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEndpointWithCallback invokes the paielasticdatasetaccelerator.DescribeEndpoint API asynchronously
func (client *Client) DescribeEndpointWithCallback(request *DescribeEndpointRequest, callback func(response *DescribeEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEndpointResponse
		var err error
		defer close(result)
		response, err = client.DescribeEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEndpointRequest is the request struct for api DescribeEndpoint
type DescribeEndpointRequest struct {
	*requests.RoaRequest
	EndpointId string `position:"Path" name:"EndpointId"`
}

// DescribeEndpointResponse is the response struct for api DescribeEndpoint
type DescribeEndpointResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	UserId          string `json:"UserId" xml:"UserId"`
	OwnerId         string `json:"OwnerId" xml:"OwnerId"`
	GmtCreateTime   string `json:"GmtCreateTime" xml:"GmtCreateTime"`
	GmtModifiedTime string `json:"GmtModifiedTime" xml:"GmtModifiedTime"`
	Uuid            string `json:"Uuid" xml:"Uuid"`
	Name            string `json:"Name" xml:"Name"`
	Type            string `json:"Type" xml:"Type"`
	VpcId           string `json:"VpcId" xml:"VpcId"`
	VswitchId       string `json:"VswitchId" xml:"VswitchId"`
	Status          Status `json:"Status" xml:"Status"`
}

// CreateDescribeEndpointRequest creates a request to invoke DescribeEndpoint API
func CreateDescribeEndpointRequest() (request *DescribeEndpointRequest) {
	request = &DescribeEndpointRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PAIElasticDatasetAccelerator", "2022-08-01", "DescribeEndpoint", "/api/v1/endpoints/[EndpointId]", "datasetacc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeEndpointResponse creates a response to parse from DescribeEndpoint response
func CreateDescribeEndpointResponse() (response *DescribeEndpointResponse) {
	response = &DescribeEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
