package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveSearchStrategy invokes the opensearch.RemoveSearchStrategy API synchronously
func (client *Client) RemoveSearchStrategy(request *RemoveSearchStrategyRequest) (response *RemoveSearchStrategyResponse, err error) {
	response = CreateRemoveSearchStrategyResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveSearchStrategyWithChan invokes the opensearch.RemoveSearchStrategy API asynchronously
func (client *Client) RemoveSearchStrategyWithChan(request *RemoveSearchStrategyRequest) (<-chan *RemoveSearchStrategyResponse, <-chan error) {
	responseChan := make(chan *RemoveSearchStrategyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveSearchStrategy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveSearchStrategyWithCallback invokes the opensearch.RemoveSearchStrategy API asynchronously
func (client *Client) RemoveSearchStrategyWithCallback(request *RemoveSearchStrategyRequest, callback func(response *RemoveSearchStrategyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveSearchStrategyResponse
		var err error
		defer close(result)
		response, err = client.RemoveSearchStrategy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveSearchStrategyRequest is the request struct for api RemoveSearchStrategy
type RemoveSearchStrategyRequest struct {
	*requests.RoaRequest
	StrategyName     string `position:"Path" name:"strategyName"`
	AppId            string `position:"Path" name:"appId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// RemoveSearchStrategyResponse is the response struct for api RemoveSearchStrategy
type RemoveSearchStrategyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRemoveSearchStrategyRequest creates a request to invoke RemoveSearchStrategy API
func CreateRemoveSearchStrategyRequest() (request *RemoveSearchStrategyRequest) {
	request = &RemoveSearchStrategyRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RemoveSearchStrategy", "/v4/openapi/app-groups/[appGroupIdentity]/apps/[appId]/search-strategies/[strategyName]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveSearchStrategyResponse creates a response to parse from RemoveSearchStrategy response
func CreateRemoveSearchStrategyResponse() (response *RemoveSearchStrategyResponse) {
	response = &RemoveSearchStrategyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
