package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateProjectModifyRecords invokes the oceanbasepro.CreateProjectModifyRecords API synchronously
func (client *Client) CreateProjectModifyRecords(request *CreateProjectModifyRecordsRequest) (response *CreateProjectModifyRecordsResponse, err error) {
	response = CreateCreateProjectModifyRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateProjectModifyRecordsWithChan invokes the oceanbasepro.CreateProjectModifyRecords API asynchronously
func (client *Client) CreateProjectModifyRecordsWithChan(request *CreateProjectModifyRecordsRequest) (<-chan *CreateProjectModifyRecordsResponse, <-chan error) {
	responseChan := make(chan *CreateProjectModifyRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateProjectModifyRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateProjectModifyRecordsWithCallback invokes the oceanbasepro.CreateProjectModifyRecords API asynchronously
func (client *Client) CreateProjectModifyRecordsWithCallback(request *CreateProjectModifyRecordsRequest, callback func(response *CreateProjectModifyRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateProjectModifyRecordsResponse
		var err error
		defer close(result)
		response, err = client.CreateProjectModifyRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateProjectModifyRecordsRequest is the request struct for api CreateProjectModifyRecords
type CreateProjectModifyRecordsRequest struct {
	*requests.RpcRequest
	Databases *[]CreateProjectModifyRecordsDatabases `position:"Body" name:"Databases"  type:"Json"`
	Id        string                                 `position:"Body" name:"Id"`
}

// CreateProjectModifyRecordsDatabases is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabases struct {
	MappedName     string                                                   `name:"MappedName"`
	SpecificViews  *[]CreateProjectModifyRecordsDatabasesSpecificViewsItem  `name:"SpecificViews" type:"Repeated"`
	Tables         *[]CreateProjectModifyRecordsDatabasesTablesItem         `name:"Tables" type:"Repeated"`
	Name           string                                                   `name:"Name"`
	Id             string                                                   `name:"Id"`
	SpecificTables *[]CreateProjectModifyRecordsDatabasesSpecificTablesItem `name:"SpecificTables" type:"Repeated"`
	Views          *[]CreateProjectModifyRecordsDatabasesViewsItem          `name:"Views" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesSpecificViewsItem is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesSpecificViewsItem struct {
	MappedName     string                                                             `name:"MappedName"`
	FilterColumns  *[]string                                                          `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectModifyRecordsDatabasesSpecificViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                             `name:"Name"`
	WhereClause    string                                                             `name:"WhereClause"`
	Id             string                                                             `name:"Id"`
	ShardColumns   *[]string                                                          `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesTablesItem is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesTablesItem struct {
	MappedName     string                                                      `name:"MappedName"`
	FilterColumns  *[]string                                                   `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectModifyRecordsDatabasesTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                      `name:"Name"`
	WhereClause    string                                                      `name:"WhereClause"`
	Id             string                                                      `name:"Id"`
	ShardColumns   *[]string                                                   `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesSpecificTablesItem is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesSpecificTablesItem struct {
	MappedName     string                                                              `name:"MappedName"`
	FilterColumns  *[]string                                                           `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectModifyRecordsDatabasesSpecificTablesItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                              `name:"Name"`
	WhereClause    string                                                              `name:"WhereClause"`
	Id             string                                                              `name:"Id"`
	ShardColumns   *[]string                                                           `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesViewsItem is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesViewsItem struct {
	MappedName     string                                                     `name:"MappedName"`
	FilterColumns  *[]string                                                  `name:"FilterColumns" type:"Repeated"`
	AdbTableSchema CreateProjectModifyRecordsDatabasesViewsItemAdbTableSchema `name:"AdbTableSchema" type:"Struct"`
	Name           string                                                     `name:"Name"`
	WhereClause    string                                                     `name:"WhereClause"`
	Id             string                                                     `name:"Id"`
	ShardColumns   *[]string                                                  `name:"ShardColumns" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesSpecificViewsItemAdbTableSchema is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesSpecificViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesTablesItemAdbTableSchema is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesSpecificTablesItemAdbTableSchema is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesSpecificTablesItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectModifyRecordsDatabasesViewsItemAdbTableSchema is a repeated param struct in CreateProjectModifyRecordsRequest
type CreateProjectModifyRecordsDatabasesViewsItemAdbTableSchema struct {
	PrimaryKeys        *[]string `name:"PrimaryKeys" type:"Repeated"`
	PartitionStatement string    `name:"PartitionStatement"`
	PartitionLifeCycle string    `name:"PartitionLifeCycle"`
	DistributedKeys    *[]string `name:"DistributedKeys" type:"Repeated"`
}

// CreateProjectModifyRecordsResponse is the response struct for api CreateProjectModifyRecords
type CreateProjectModifyRecordsResponse struct {
	*responses.BaseResponse
}

// CreateCreateProjectModifyRecordsRequest creates a request to invoke CreateProjectModifyRecords API
func CreateCreateProjectModifyRecordsRequest() (request *CreateProjectModifyRecordsRequest) {
	request = &CreateProjectModifyRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CreateProjectModifyRecords", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateProjectModifyRecordsResponse creates a response to parse from CreateProjectModifyRecords response
func CreateCreateProjectModifyRecordsResponse() (response *CreateProjectModifyRecordsResponse) {
	response = &CreateProjectModifyRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
