package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelProjectModifyRecord invokes the oceanbasepro.CancelProjectModifyRecord API synchronously
func (client *Client) CancelProjectModifyRecord(request *CancelProjectModifyRecordRequest) (response *CancelProjectModifyRecordResponse, err error) {
	response = CreateCancelProjectModifyRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CancelProjectModifyRecordWithChan invokes the oceanbasepro.CancelProjectModifyRecord API asynchronously
func (client *Client) CancelProjectModifyRecordWithChan(request *CancelProjectModifyRecordRequest) (<-chan *CancelProjectModifyRecordResponse, <-chan error) {
	responseChan := make(chan *CancelProjectModifyRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelProjectModifyRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelProjectModifyRecordWithCallback invokes the oceanbasepro.CancelProjectModifyRecord API asynchronously
func (client *Client) CancelProjectModifyRecordWithCallback(request *CancelProjectModifyRecordRequest, callback func(response *CancelProjectModifyRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelProjectModifyRecordResponse
		var err error
		defer close(result)
		response, err = client.CancelProjectModifyRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelProjectModifyRecordRequest is the request struct for api CancelProjectModifyRecord
type CancelProjectModifyRecordRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// CancelProjectModifyRecordResponse is the response struct for api CancelProjectModifyRecord
type CancelProjectModifyRecordResponse struct {
	*responses.BaseResponse
}

// CreateCancelProjectModifyRecordRequest creates a request to invoke CancelProjectModifyRecord API
func CreateCancelProjectModifyRecordRequest() (request *CancelProjectModifyRecordRequest) {
	request = &CancelProjectModifyRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "CancelProjectModifyRecord", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelProjectModifyRecordResponse creates a response to parse from CancelProjectModifyRecord response
func CreateCancelProjectModifyRecordResponse() (response *CancelProjectModifyRecordResponse) {
	response = &CancelProjectModifyRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
