package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecurityGroupRule invokes the mse.ListSecurityGroupRule API synchronously
func (client *Client) ListSecurityGroupRule(request *ListSecurityGroupRuleRequest) (response *ListSecurityGroupRuleResponse, err error) {
	response = CreateListSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecurityGroupRuleWithChan invokes the mse.ListSecurityGroupRule API asynchronously
func (client *Client) ListSecurityGroupRuleWithChan(request *ListSecurityGroupRuleRequest) (<-chan *ListSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *ListSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecurityGroupRuleWithCallback invokes the mse.ListSecurityGroupRule API asynchronously
func (client *Client) ListSecurityGroupRuleWithCallback(request *ListSecurityGroupRuleRequest, callback func(response *ListSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.ListSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecurityGroupRuleRequest is the request struct for api ListSecurityGroupRule
type ListSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	MseSessionId    string `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// ListSecurityGroupRuleResponse is the response struct for api ListSecurityGroupRule
type ListSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string  `json:"Message" xml:"Message"`
	Code           int     `json:"Code" xml:"Code"`
	Success        bool    `json:"Success" xml:"Success"`
	Data           []Rules `json:"Data" xml:"Data"`
}

// CreateListSecurityGroupRuleRequest creates a request to invoke ListSecurityGroupRule API
func CreateListSecurityGroupRuleRequest() (request *ListSecurityGroupRuleRequest) {
	request = &ListSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListSecurityGroupRule", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSecurityGroupRuleResponse creates a response to parse from ListSecurityGroupRule response
func CreateListSecurityGroupRuleResponse() (response *ListSecurityGroupRuleResponse) {
	response = &ListSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
