package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTimeTemplate invokes the linkvisual.QueryTimeTemplate API synchronously
func (client *Client) QueryTimeTemplate(request *QueryTimeTemplateRequest) (response *QueryTimeTemplateResponse, err error) {
	response = CreateQueryTimeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTimeTemplateWithChan invokes the linkvisual.QueryTimeTemplate API asynchronously
func (client *Client) QueryTimeTemplateWithChan(request *QueryTimeTemplateRequest) (<-chan *QueryTimeTemplateResponse, <-chan error) {
	responseChan := make(chan *QueryTimeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTimeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTimeTemplateWithCallback invokes the linkvisual.QueryTimeTemplate API asynchronously
func (client *Client) QueryTimeTemplateWithCallback(request *QueryTimeTemplateRequest, callback func(response *QueryTimeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTimeTemplateResponse
		var err error
		defer close(result)
		response, err = client.QueryTimeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTimeTemplateRequest is the request struct for api QueryTimeTemplate
type QueryTimeTemplateRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// QueryTimeTemplateResponse is the response struct for api QueryTimeTemplate
type QueryTimeTemplateResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryTimeTemplateRequest creates a request to invoke QueryTimeTemplate API
func CreateQueryTimeTemplateRequest() (request *QueryTimeTemplateRequest) {
	request = &QueryTimeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryTimeTemplate", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTimeTemplateResponse creates a response to parse from QueryTimeTemplate response
func CreateQueryTimeTemplateResponse() (response *QueryTimeTemplateResponse) {
	response = &QueryTimeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
