package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRecordDownloadJobById invokes the linkvisual.QueryRecordDownloadJobById API synchronously
func (client *Client) QueryRecordDownloadJobById(request *QueryRecordDownloadJobByIdRequest) (response *QueryRecordDownloadJobByIdResponse, err error) {
	response = CreateQueryRecordDownloadJobByIdResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRecordDownloadJobByIdWithChan invokes the linkvisual.QueryRecordDownloadJobById API asynchronously
func (client *Client) QueryRecordDownloadJobByIdWithChan(request *QueryRecordDownloadJobByIdRequest) (<-chan *QueryRecordDownloadJobByIdResponse, <-chan error) {
	responseChan := make(chan *QueryRecordDownloadJobByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRecordDownloadJobById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRecordDownloadJobByIdWithCallback invokes the linkvisual.QueryRecordDownloadJobById API asynchronously
func (client *Client) QueryRecordDownloadJobByIdWithCallback(request *QueryRecordDownloadJobByIdRequest, callback func(response *QueryRecordDownloadJobByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRecordDownloadJobByIdResponse
		var err error
		defer close(result)
		response, err = client.QueryRecordDownloadJobById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRecordDownloadJobByIdRequest is the request struct for api QueryRecordDownloadJobById
type QueryRecordDownloadJobByIdRequest struct {
	*requests.RpcRequest
	JobId         string `position:"Query" name:"JobId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// QueryRecordDownloadJobByIdResponse is the response struct for api QueryRecordDownloadJobById
type QueryRecordDownloadJobByIdResponse struct {
	*responses.BaseResponse
	Code         string                           `json:"Code" xml:"Code"`
	ErrorMessage string                           `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                           `json:"RequestId" xml:"RequestId"`
	Success      bool                             `json:"Success" xml:"Success"`
	Data         DataInQueryRecordDownloadJobById `json:"Data" xml:"Data"`
}

// CreateQueryRecordDownloadJobByIdRequest creates a request to invoke QueryRecordDownloadJobById API
func CreateQueryRecordDownloadJobByIdRequest() (request *QueryRecordDownloadJobByIdRequest) {
	request = &QueryRecordDownloadJobByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryRecordDownloadJobById", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRecordDownloadJobByIdResponse creates a response to parse from QueryRecordDownloadJobById response
func CreateQueryRecordDownloadJobByIdResponse() (response *QueryRecordDownloadJobByIdResponse) {
	response = &QueryRecordDownloadJobByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
