package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePictureSearchJob invokes the linkvisual.CreatePictureSearchJob API synchronously
func (client *Client) CreatePictureSearchJob(request *CreatePictureSearchJobRequest) (response *CreatePictureSearchJobResponse, err error) {
	response = CreateCreatePictureSearchJobResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePictureSearchJobWithChan invokes the linkvisual.CreatePictureSearchJob API asynchronously
func (client *Client) CreatePictureSearchJobWithChan(request *CreatePictureSearchJobRequest) (<-chan *CreatePictureSearchJobResponse, <-chan error) {
	responseChan := make(chan *CreatePictureSearchJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePictureSearchJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePictureSearchJobWithCallback invokes the linkvisual.CreatePictureSearchJob API asynchronously
func (client *Client) CreatePictureSearchJobWithCallback(request *CreatePictureSearchJobRequest, callback func(response *CreatePictureSearchJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePictureSearchJobResponse
		var err error
		defer close(result)
		response, err = client.CreatePictureSearchJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePictureSearchJobRequest is the request struct for api CreatePictureSearchJob
type CreatePictureSearchJobRequest struct {
	*requests.RpcRequest
	Threshold         requests.Float   `position:"Query" name:"Threshold"`
	SearchPicUrl      string           `position:"Query" name:"SearchPicUrl"`
	StartTime         requests.Integer `position:"Query" name:"StartTime"`
	PictureSearchType requests.Integer `position:"Query" name:"PictureSearchType"`
	BodyThreshold     requests.Float   `position:"Query" name:"BodyThreshold"`
	EndTime           requests.Integer `position:"Query" name:"EndTime"`
	ApiProduct        string           `position:"Body" name:"ApiProduct"`
	ApiRevision       string           `position:"Body" name:"ApiRevision"`
	AppInstanceId     string           `position:"Query" name:"AppInstanceId"`
}

// CreatePictureSearchJobResponse is the response struct for api CreatePictureSearchJob
type CreatePictureSearchJobResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateCreatePictureSearchJobRequest creates a request to invoke CreatePictureSearchJob API
func CreateCreatePictureSearchJobRequest() (request *CreatePictureSearchJobRequest) {
	request = &CreatePictureSearchJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "CreatePictureSearchJob", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePictureSearchJobResponse creates a response to parse from CreatePictureSearchJob response
func CreateCreatePictureSearchJobResponse() (response *CreatePictureSearchJobResponse) {
	response = &CreatePictureSearchJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
