package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveScript invokes the iot.SaveScript API synchronously
func (client *Client) SaveScript(request *SaveScriptRequest) (response *SaveScriptResponse, err error) {
	response = CreateSaveScriptResponse()
	err = client.DoAction(request, response)
	return
}

// SaveScriptWithChan invokes the iot.SaveScript API asynchronously
func (client *Client) SaveScriptWithChan(request *SaveScriptRequest) (<-chan *SaveScriptResponse, <-chan error) {
	responseChan := make(chan *SaveScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveScriptWithCallback invokes the iot.SaveScript API asynchronously
func (client *Client) SaveScriptWithCallback(request *SaveScriptRequest, callback func(response *SaveScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveScriptResponse
		var err error
		defer close(result)
		response, err = client.SaveScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveScriptRequest is the request struct for api SaveScript
type SaveScriptRequest struct {
	*requests.RpcRequest
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ScriptDraft   string           `position:"Query" name:"ScriptDraft"`
	ParserId      requests.Integer `position:"Query" name:"ParserId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// SaveScriptResponse is the response struct for api SaveScript
type SaveScriptResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateSaveScriptRequest creates a request to invoke SaveScript API
func CreateSaveScriptRequest() (request *SaveScriptRequest) {
	request = &SaveScriptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "SaveScript", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveScriptResponse creates a response to parse from SaveScript response
func CreateSaveScriptResponse() (response *SaveScriptResponse) {
	response = &SaveScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
