package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSoundCode invokes the iot.CreateSoundCode API synchronously
func (client *Client) CreateSoundCode(request *CreateSoundCodeRequest) (response *CreateSoundCodeResponse, err error) {
	response = CreateCreateSoundCodeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSoundCodeWithChan invokes the iot.CreateSoundCode API asynchronously
func (client *Client) CreateSoundCodeWithChan(request *CreateSoundCodeRequest) (<-chan *CreateSoundCodeResponse, <-chan error) {
	responseChan := make(chan *CreateSoundCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSoundCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSoundCodeWithCallback invokes the iot.CreateSoundCode API asynchronously
func (client *Client) CreateSoundCodeWithCallback(request *CreateSoundCodeRequest, callback func(response *CreateSoundCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSoundCodeResponse
		var err error
		defer close(result)
		response, err = client.CreateSoundCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSoundCodeRequest is the request struct for api CreateSoundCode
type CreateSoundCodeRequest struct {
	*requests.RpcRequest
	Duration         requests.Integer `position:"Body" name:"Duration"`
	IotInstanceId    string           `position:"Body" name:"IotInstanceId"`
	SoundCodeContent string           `position:"Body" name:"SoundCodeContent"`
	ApiProduct       string           `position:"Body" name:"ApiProduct"`
	Name             string           `position:"Body" name:"Name"`
	ApiRevision      string           `position:"Body" name:"ApiRevision"`
	OpenType         string           `position:"Body" name:"OpenType"`
}

// CreateSoundCodeResponse is the response struct for api CreateSoundCode
type CreateSoundCodeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         string `json:"Data" xml:"Data"`
}

// CreateCreateSoundCodeRequest creates a request to invoke CreateSoundCode API
func CreateCreateSoundCodeRequest() (request *CreateSoundCodeRequest) {
	request = &CreateSoundCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateSoundCode", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSoundCodeResponse creates a response to parse from CreateSoundCode response
func CreateCreateSoundCodeResponse() (response *CreateSoundCodeResponse) {
	response = &CreateSoundCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
