package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCollector invokes the elasticsearch.UpdateCollector API synchronously
func (client *Client) UpdateCollector(request *UpdateCollectorRequest) (response *UpdateCollectorResponse, err error) {
	response = CreateUpdateCollectorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCollectorWithChan invokes the elasticsearch.UpdateCollector API asynchronously
func (client *Client) UpdateCollectorWithChan(request *UpdateCollectorRequest) (<-chan *UpdateCollectorResponse, <-chan error) {
	responseChan := make(chan *UpdateCollectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCollector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCollectorWithCallback invokes the elasticsearch.UpdateCollector API asynchronously
func (client *Client) UpdateCollectorWithCallback(request *UpdateCollectorRequest, callback func(response *UpdateCollectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCollectorResponse
		var err error
		defer close(result)
		response, err = client.UpdateCollector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCollectorRequest is the request struct for api UpdateCollector
type UpdateCollectorRequest struct {
	*requests.RoaRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	Body        string `position:"Body" name:"body"`
	ResId       string `position:"Path" name:"ResId"`
}

// UpdateCollectorResponse is the response struct for api UpdateCollector
type UpdateCollectorResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Result    ResultInUpdateCollector `json:"Result" xml:"Result"`
}

// CreateUpdateCollectorRequest creates a request to invoke UpdateCollector API
func CreateUpdateCollectorRequest() (request *UpdateCollectorRequest) {
	request = &UpdateCollectorRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateCollector", "/openapi/collectors/[ResId]", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateCollectorResponse creates a response to parse from UpdateCollector response
func CreateUpdateCollectorResponse() (response *UpdateCollectorResponse) {
	response = &UpdateCollectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
