package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnassignLeniPrivateIpAddress invokes the eflo.UnassignLeniPrivateIpAddress API synchronously
func (client *Client) UnassignLeniPrivateIpAddress(request *UnassignLeniPrivateIpAddressRequest) (response *UnassignLeniPrivateIpAddressResponse, err error) {
	response = CreateUnassignLeniPrivateIpAddressResponse()
	err = client.DoAction(request, response)
	return
}

// UnassignLeniPrivateIpAddressWithChan invokes the eflo.UnassignLeniPrivateIpAddress API asynchronously
func (client *Client) UnassignLeniPrivateIpAddressWithChan(request *UnassignLeniPrivateIpAddressRequest) (<-chan *UnassignLeniPrivateIpAddressResponse, <-chan error) {
	responseChan := make(chan *UnassignLeniPrivateIpAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnassignLeniPrivateIpAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnassignLeniPrivateIpAddressWithCallback invokes the eflo.UnassignLeniPrivateIpAddress API asynchronously
func (client *Client) UnassignLeniPrivateIpAddressWithCallback(request *UnassignLeniPrivateIpAddressRequest, callback func(response *UnassignLeniPrivateIpAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnassignLeniPrivateIpAddressResponse
		var err error
		defer close(result)
		response, err = client.UnassignLeniPrivateIpAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnassignLeniPrivateIpAddressRequest is the request struct for api UnassignLeniPrivateIpAddress
type UnassignLeniPrivateIpAddressRequest struct {
	*requests.RpcRequest
	ClientToken               string `position:"Body" name:"ClientToken"`
	IpName                    string `position:"Body" name:"IpName"`
	ElasticNetworkInterfaceId string `position:"Body" name:"ElasticNetworkInterfaceId"`
}

// UnassignLeniPrivateIpAddressResponse is the response struct for api UnassignLeniPrivateIpAddress
type UnassignLeniPrivateIpAddressResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateUnassignLeniPrivateIpAddressRequest creates a request to invoke UnassignLeniPrivateIpAddress API
func CreateUnassignLeniPrivateIpAddressRequest() (request *UnassignLeniPrivateIpAddressRequest) {
	request = &UnassignLeniPrivateIpAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UnassignLeniPrivateIpAddress", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnassignLeniPrivateIpAddressResponse creates a response to parse from UnassignLeniPrivateIpAddress response
func CreateUnassignLeniPrivateIpAddressResponse() (response *UnassignLeniPrivateIpAddressResponse) {
	response = &UnassignLeniPrivateIpAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
