package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachClassicLinkVpc invokes the ecs.DetachClassicLinkVpc API synchronously
func (client *Client) DetachClassicLinkVpc(request *DetachClassicLinkVpcRequest) (response *DetachClassicLinkVpcResponse, err error) {
	response = CreateDetachClassicLinkVpcResponse()
	err = client.DoAction(request, response)
	return
}

// DetachClassicLinkVpcWithChan invokes the ecs.DetachClassicLinkVpc API asynchronously
func (client *Client) DetachClassicLinkVpcWithChan(request *DetachClassicLinkVpcRequest) (<-chan *DetachClassicLinkVpcResponse, <-chan error) {
	responseChan := make(chan *DetachClassicLinkVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachClassicLinkVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachClassicLinkVpcWithCallback invokes the ecs.DetachClassicLinkVpc API asynchronously
func (client *Client) DetachClassicLinkVpcWithCallback(request *DetachClassicLinkVpcRequest, callback func(response *DetachClassicLinkVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachClassicLinkVpcResponse
		var err error
		defer close(result)
		response, err = client.DetachClassicLinkVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachClassicLinkVpcRequest is the request struct for api DetachClassicLinkVpc
type DetachClassicLinkVpcRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	VpcId                string           `position:"Query" name:"VpcId"`
}

// DetachClassicLinkVpcResponse is the response struct for api DetachClassicLinkVpc
type DetachClassicLinkVpcResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachClassicLinkVpcRequest creates a request to invoke DetachClassicLinkVpc API
func CreateDetachClassicLinkVpcRequest() (request *DetachClassicLinkVpcRequest) {
	request = &DetachClassicLinkVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DetachClassicLinkVpc", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachClassicLinkVpcResponse creates a response to parse from DetachClassicLinkVpc response
func CreateDetachClassicLinkVpcResponse() (response *DetachClassicLinkVpcResponse) {
	response = &DetachClassicLinkVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
