package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteImageComponent invokes the ecs.DeleteImageComponent API synchronously
func (client *Client) DeleteImageComponent(request *DeleteImageComponentRequest) (response *DeleteImageComponentResponse, err error) {
	response = CreateDeleteImageComponentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteImageComponentWithChan invokes the ecs.DeleteImageComponent API asynchronously
func (client *Client) DeleteImageComponentWithChan(request *DeleteImageComponentRequest) (<-chan *DeleteImageComponentResponse, <-chan error) {
	responseChan := make(chan *DeleteImageComponentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteImageComponent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteImageComponentWithCallback invokes the ecs.DeleteImageComponent API asynchronously
func (client *Client) DeleteImageComponentWithCallback(request *DeleteImageComponentRequest, callback func(response *DeleteImageComponentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteImageComponentResponse
		var err error
		defer close(result)
		response, err = client.DeleteImageComponent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteImageComponentRequest is the request struct for api DeleteImageComponent
type DeleteImageComponentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ImageComponentId     string           `position:"Query" name:"ImageComponentId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteImageComponentResponse is the response struct for api DeleteImageComponent
type DeleteImageComponentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteImageComponentRequest creates a request to invoke DeleteImageComponent API
func CreateDeleteImageComponentRequest() (request *DeleteImageComponentRequest) {
	request = &DeleteImageComponentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DeleteImageComponent", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteImageComponentResponse creates a response to parse from DeleteImageComponent response
func CreateDeleteImageComponentResponse() (response *DeleteImageComponentResponse) {
	response = &DeleteImageComponentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
