package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopOversoldGroup invokes the ecd.ModifyDesktopOversoldGroup API synchronously
func (client *Client) ModifyDesktopOversoldGroup(request *ModifyDesktopOversoldGroupRequest) (response *ModifyDesktopOversoldGroupResponse, err error) {
	response = CreateModifyDesktopOversoldGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopOversoldGroupWithChan invokes the ecd.ModifyDesktopOversoldGroup API asynchronously
func (client *Client) ModifyDesktopOversoldGroupWithChan(request *ModifyDesktopOversoldGroupRequest) (<-chan *ModifyDesktopOversoldGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopOversoldGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopOversoldGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopOversoldGroupWithCallback invokes the ecd.ModifyDesktopOversoldGroup API asynchronously
func (client *Client) ModifyDesktopOversoldGroupWithCallback(request *ModifyDesktopOversoldGroupRequest, callback func(response *ModifyDesktopOversoldGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopOversoldGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopOversoldGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopOversoldGroupRequest is the request struct for api ModifyDesktopOversoldGroup
type ModifyDesktopOversoldGroupRequest struct {
	*requests.RpcRequest
	ImageId                string           `position:"Query" name:"ImageId"`
	OversoldUserCount      requests.Integer `position:"Query" name:"OversoldUserCount"`
	Description            string           `position:"Query" name:"Description"`
	OversoldWarn           requests.Integer `position:"Query" name:"OversoldWarn"`
	IdleDisconnectDuration requests.Integer `position:"Query" name:"IdleDisconnectDuration"`
	OversoldGroupId        string           `position:"Query" name:"OversoldGroupId"`
	StopDuration           requests.Integer `position:"Query" name:"StopDuration"`
	KeepDuration           requests.Integer `position:"Query" name:"KeepDuration"`
	Name                   string           `position:"Query" name:"Name"`
	ConcurrenceCount       requests.Integer `position:"Query" name:"ConcurrenceCount"`
	PolicyGroupId          string           `position:"Query" name:"PolicyGroupId"`
}

// ModifyDesktopOversoldGroupResponse is the response struct for api ModifyDesktopOversoldGroup
type ModifyDesktopOversoldGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyDesktopOversoldGroupRequest creates a request to invoke ModifyDesktopOversoldGroup API
func CreateModifyDesktopOversoldGroupRequest() (request *ModifyDesktopOversoldGroupRequest) {
	request = &ModifyDesktopOversoldGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopOversoldGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopOversoldGroupResponse creates a response to parse from ModifyDesktopOversoldGroup response
func CreateModifyDesktopOversoldGroupResponse() (response *ModifyDesktopOversoldGroupResponse) {
	response = &ModifyDesktopOversoldGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
