package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserConnectTime invokes the ecd.DescribeUserConnectTime API synchronously
func (client *Client) DescribeUserConnectTime(request *DescribeUserConnectTimeRequest) (response *DescribeUserConnectTimeResponse, err error) {
	response = CreateDescribeUserConnectTimeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserConnectTimeWithChan invokes the ecd.DescribeUserConnectTime API asynchronously
func (client *Client) DescribeUserConnectTimeWithChan(request *DescribeUserConnectTimeRequest) (<-chan *DescribeUserConnectTimeResponse, <-chan error) {
	responseChan := make(chan *DescribeUserConnectTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserConnectTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserConnectTimeWithCallback invokes the ecd.DescribeUserConnectTime API asynchronously
func (client *Client) DescribeUserConnectTimeWithCallback(request *DescribeUserConnectTimeRequest, callback func(response *DescribeUserConnectTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserConnectTimeResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserConnectTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserConnectTimeRequest is the request struct for api DescribeUserConnectTime
type DescribeUserConnectTimeRequest struct {
	*requests.RpcRequest
	UserDesktopId   string           `position:"Query" name:"UserDesktopId"`
	StartTime       string           `position:"Query" name:"StartTime"`
	NextToken       string           `position:"Query" name:"NextToken"`
	EndUserId       string           `position:"Query" name:"EndUserId"`
	OversoldGroupId string           `position:"Query" name:"OversoldGroupId"`
	UserGroupId     string           `position:"Query" name:"UserGroupId"`
	EndTime         string           `position:"Query" name:"EndTime"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeUserConnectTimeResponse is the response struct for api DescribeUserConnectTime
type DescribeUserConnectTimeResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Count     int        `json:"Count" xml:"Count"`
	NextToken string     `json:"NextToken" xml:"NextToken"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateDescribeUserConnectTimeRequest creates a request to invoke DescribeUserConnectTime API
func CreateDescribeUserConnectTimeRequest() (request *DescribeUserConnectTimeRequest) {
	request = &DescribeUserConnectTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeUserConnectTime", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserConnectTimeResponse creates a response to parse from DescribeUserConnectTime response
func CreateDescribeUserConnectTimeResponse() (response *DescribeUserConnectTimeResponse) {
	response = &DescribeUserConnectTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
