package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAutoSnapshotPolicy invokes the ecd.DescribeAutoSnapshotPolicy API synchronously
func (client *Client) DescribeAutoSnapshotPolicy(request *DescribeAutoSnapshotPolicyRequest) (response *DescribeAutoSnapshotPolicyResponse, err error) {
	response = CreateDescribeAutoSnapshotPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAutoSnapshotPolicyWithChan invokes the ecd.DescribeAutoSnapshotPolicy API asynchronously
func (client *Client) DescribeAutoSnapshotPolicyWithChan(request *DescribeAutoSnapshotPolicyRequest) (<-chan *DescribeAutoSnapshotPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeAutoSnapshotPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAutoSnapshotPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAutoSnapshotPolicyWithCallback invokes the ecd.DescribeAutoSnapshotPolicy API asynchronously
func (client *Client) DescribeAutoSnapshotPolicyWithCallback(request *DescribeAutoSnapshotPolicyRequest, callback func(response *DescribeAutoSnapshotPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAutoSnapshotPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeAutoSnapshotPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAutoSnapshotPolicyRequest is the request struct for api DescribeAutoSnapshotPolicy
type DescribeAutoSnapshotPolicyRequest struct {
	*requests.RpcRequest
	PolicyId   string           `position:"Query" name:"PolicyId"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	PolicyName string           `position:"Query" name:"PolicyName"`
}

// DescribeAutoSnapshotPolicyResponse is the response struct for api DescribeAutoSnapshotPolicy
type DescribeAutoSnapshotPolicyResponse struct {
	*responses.BaseResponse
	NextToken            string               `json:"NextToken" xml:"NextToken"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	AutoSnapshotPolicies []AutoSnapshotPolicy `json:"AutoSnapshotPolicies" xml:"AutoSnapshotPolicies"`
}

// CreateDescribeAutoSnapshotPolicyRequest creates a request to invoke DescribeAutoSnapshotPolicy API
func CreateDescribeAutoSnapshotPolicyRequest() (request *DescribeAutoSnapshotPolicyRequest) {
	request = &DescribeAutoSnapshotPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeAutoSnapshotPolicy", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAutoSnapshotPolicyResponse creates a response to parse from DescribeAutoSnapshotPolicy response
func CreateDescribeAutoSnapshotPolicyResponse() (response *DescribeAutoSnapshotPolicyResponse) {
	response = &DescribeAutoSnapshotPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
