package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDiskReplicaGroup invokes the ebs.DeleteDiskReplicaGroup API synchronously
func (client *Client) DeleteDiskReplicaGroup(request *DeleteDiskReplicaGroupRequest) (response *DeleteDiskReplicaGroupResponse, err error) {
	response = CreateDeleteDiskReplicaGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDiskReplicaGroupWithChan invokes the ebs.DeleteDiskReplicaGroup API asynchronously
func (client *Client) DeleteDiskReplicaGroupWithChan(request *DeleteDiskReplicaGroupRequest) (<-chan *DeleteDiskReplicaGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteDiskReplicaGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDiskReplicaGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDiskReplicaGroupWithCallback invokes the ebs.DeleteDiskReplicaGroup API asynchronously
func (client *Client) DeleteDiskReplicaGroupWithCallback(request *DeleteDiskReplicaGroupRequest, callback func(response *DeleteDiskReplicaGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDiskReplicaGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteDiskReplicaGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDiskReplicaGroupRequest is the request struct for api DeleteDiskReplicaGroup
type DeleteDiskReplicaGroupRequest struct {
	*requests.RpcRequest
	ClientToken    string `position:"Query" name:"ClientToken"`
	ReplicaGroupId string `position:"Query" name:"ReplicaGroupId"`
}

// DeleteDiskReplicaGroupResponse is the response struct for api DeleteDiskReplicaGroup
type DeleteDiskReplicaGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDiskReplicaGroupRequest creates a request to invoke DeleteDiskReplicaGroup API
func CreateDeleteDiskReplicaGroupRequest() (request *DeleteDiskReplicaGroupRequest) {
	request = &DeleteDiskReplicaGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DeleteDiskReplicaGroup", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDiskReplicaGroupResponse creates a response to parse from DeleteDiskReplicaGroup response
func CreateDeleteDiskReplicaGroupResponse() (response *DeleteDiskReplicaGroupResponse) {
	response = &DeleteDiskReplicaGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
