package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSmsTemplate invokes the dysmsapi.GetSmsTemplate API synchronously
func (client *Client) GetSmsTemplate(request *GetSmsTemplateRequest) (response *GetSmsTemplateResponse, err error) {
	response = CreateGetSmsTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetSmsTemplateWithChan invokes the dysmsapi.GetSmsTemplate API asynchronously
func (client *Client) GetSmsTemplateWithChan(request *GetSmsTemplateRequest) (<-chan *GetSmsTemplateResponse, <-chan error) {
	responseChan := make(chan *GetSmsTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSmsTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSmsTemplateWithCallback invokes the dysmsapi.GetSmsTemplate API asynchronously
func (client *Client) GetSmsTemplateWithCallback(request *GetSmsTemplateRequest, callback func(response *GetSmsTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSmsTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetSmsTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSmsTemplateRequest is the request struct for api GetSmsTemplate
type GetSmsTemplateRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	TemplateCode         string           `position:"Query" name:"TemplateCode"`
}

// GetSmsTemplateResponse is the response struct for api GetSmsTemplate
type GetSmsTemplateResponse struct {
	*responses.BaseResponse
	RequestId           string                      `json:"RequestId" xml:"RequestId"`
	Code                string                      `json:"Code" xml:"Code"`
	Message             string                      `json:"Message" xml:"Message"`
	TemplateName        string                      `json:"TemplateName" xml:"TemplateName"`
	TemplateCode        string                      `json:"TemplateCode" xml:"TemplateCode"`
	TemplateContent     string                      `json:"TemplateContent" xml:"TemplateContent"`
	TemplateType        string                      `json:"TemplateType" xml:"TemplateType"`
	TemplateStatus      string                      `json:"TemplateStatus" xml:"TemplateStatus"`
	RelatedSignName     string                      `json:"RelatedSignName" xml:"RelatedSignName"`
	TemplateTag         int                         `json:"TemplateTag" xml:"TemplateTag"`
	OrderId             string                      `json:"OrderId" xml:"OrderId"`
	VariableAttribute   string                      `json:"VariableAttribute" xml:"VariableAttribute"`
	Remark              string                      `json:"Remark" xml:"Remark"`
	CreateDate          string                      `json:"CreateDate" xml:"CreateDate"`
	IntlType            int                         `json:"IntlType" xml:"IntlType"`
	ApplyScene          string                      `json:"ApplyScene" xml:"ApplyScene"`
	VendorAuditStatus   map[string]interface{}      `json:"VendorAuditStatus" xml:"VendorAuditStatus"`
	FileUrlList         FileUrlListInGetSmsTemplate `json:"FileUrlList" xml:"FileUrlList"`
	MoreDataFileUrlList MoreDataFileUrlList         `json:"MoreDataFileUrlList" xml:"MoreDataFileUrlList"`
	AuditInfo           AuditInfo                   `json:"AuditInfo" xml:"AuditInfo"`
}

// CreateGetSmsTemplateRequest creates a request to invoke GetSmsTemplate API
func CreateGetSmsTemplateRequest() (request *GetSmsTemplateRequest) {
	request = &GetSmsTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetSmsTemplate", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSmsTemplateResponse creates a response to parse from GetSmsTemplate response
func CreateGetSmsTemplateResponse() (response *GetSmsTemplateResponse) {
	response = &GetSmsTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
