package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMediaResourceId invokes the dysmsapi.GetMediaResourceId API synchronously
func (client *Client) GetMediaResourceId(request *GetMediaResourceIdRequest) (response *GetMediaResourceIdResponse, err error) {
	response = CreateGetMediaResourceIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetMediaResourceIdWithChan invokes the dysmsapi.GetMediaResourceId API asynchronously
func (client *Client) GetMediaResourceIdWithChan(request *GetMediaResourceIdRequest) (<-chan *GetMediaResourceIdResponse, <-chan error) {
	responseChan := make(chan *GetMediaResourceIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMediaResourceId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMediaResourceIdWithCallback invokes the dysmsapi.GetMediaResourceId API asynchronously
func (client *Client) GetMediaResourceIdWithCallback(request *GetMediaResourceIdRequest, callback func(response *GetMediaResourceIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMediaResourceIdResponse
		var err error
		defer close(result)
		response, err = client.GetMediaResourceId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMediaResourceIdRequest is the request struct for api GetMediaResourceId
type GetMediaResourceIdRequest struct {
	*requests.RpcRequest
	ProductCode     string           `position:"Query" name:"ProductCode"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OssKey          string           `position:"Query" name:"OssKey"`
	Memo            string           `position:"Query" name:"Memo"`
	FileSize        requests.Integer `position:"Query" name:"FileSize"`
	ExtendInfo      string           `position:"Query" name:"ExtendInfo"`
	ResourceType    requests.Integer `position:"Query" name:"ResourceType"`
}

// GetMediaResourceIdResponse is the response struct for api GetMediaResourceId
type GetMediaResourceIdResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMediaResourceIdRequest creates a request to invoke GetMediaResourceId API
func CreateGetMediaResourceIdRequest() (request *GetMediaResourceIdRequest) {
	request = &GetMediaResourceIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetMediaResourceId", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMediaResourceIdResponse creates a response to parse from GetMediaResourceId response
func CreateGetMediaResourceIdResponse() (response *GetMediaResourceIdResponse) {
	response = &GetMediaResourceIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
