package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDcdnWafGroup invokes the dcdn.ModifyDcdnWafGroup API synchronously
func (client *Client) ModifyDcdnWafGroup(request *ModifyDcdnWafGroupRequest) (response *ModifyDcdnWafGroupResponse, err error) {
	response = CreateModifyDcdnWafGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDcdnWafGroupWithChan invokes the dcdn.ModifyDcdnWafGroup API asynchronously
func (client *Client) ModifyDcdnWafGroupWithChan(request *ModifyDcdnWafGroupRequest) (<-chan *ModifyDcdnWafGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyDcdnWafGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDcdnWafGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDcdnWafGroupWithCallback invokes the dcdn.ModifyDcdnWafGroup API asynchronously
func (client *Client) ModifyDcdnWafGroupWithCallback(request *ModifyDcdnWafGroupRequest, callback func(response *ModifyDcdnWafGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDcdnWafGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyDcdnWafGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDcdnWafGroupRequest is the request struct for api ModifyDcdnWafGroup
type ModifyDcdnWafGroupRequest struct {
	*requests.RpcRequest
	Name  string           `position:"Body" name:"Name"`
	Rules string           `position:"Body" name:"Rules"`
	Id    requests.Integer `position:"Body" name:"Id"`
}

// ModifyDcdnWafGroupResponse is the response struct for api ModifyDcdnWafGroup
type ModifyDcdnWafGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDcdnWafGroupRequest creates a request to invoke ModifyDcdnWafGroup API
func CreateModifyDcdnWafGroupRequest() (request *ModifyDcdnWafGroupRequest) {
	request = &ModifyDcdnWafGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "ModifyDcdnWafGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDcdnWafGroupResponse creates a response to parse from ModifyDcdnWafGroup response
func CreateModifyDcdnWafGroupResponse() (response *ModifyDcdnWafGroupResponse) {
	response = &ModifyDcdnWafGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
