package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainTopUrlVisit invokes the dcdn.DescribeDcdnDomainTopUrlVisit API synchronously
func (client *Client) DescribeDcdnDomainTopUrlVisit(request *DescribeDcdnDomainTopUrlVisitRequest) (response *DescribeDcdnDomainTopUrlVisitResponse, err error) {
	response = CreateDescribeDcdnDomainTopUrlVisitResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainTopUrlVisitWithChan invokes the dcdn.DescribeDcdnDomainTopUrlVisit API asynchronously
func (client *Client) DescribeDcdnDomainTopUrlVisitWithChan(request *DescribeDcdnDomainTopUrlVisitRequest) (<-chan *DescribeDcdnDomainTopUrlVisitResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainTopUrlVisitResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainTopUrlVisit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainTopUrlVisitWithCallback invokes the dcdn.DescribeDcdnDomainTopUrlVisit API asynchronously
func (client *Client) DescribeDcdnDomainTopUrlVisitWithCallback(request *DescribeDcdnDomainTopUrlVisitRequest, callback func(response *DescribeDcdnDomainTopUrlVisitResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainTopUrlVisitResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainTopUrlVisit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainTopUrlVisitRequest is the request struct for api DescribeDcdnDomainTopUrlVisit
type DescribeDcdnDomainTopUrlVisitRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	SortBy     string `position:"Query" name:"SortBy"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeDcdnDomainTopUrlVisitResponse is the response struct for api DescribeDcdnDomainTopUrlVisit
type DescribeDcdnDomainTopUrlVisitResponse struct {
	*responses.BaseResponse
	StartTime  string     `json:"StartTime" xml:"StartTime"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	DomainName string     `json:"DomainName" xml:"DomainName"`
	AllUrlList AllUrlList `json:"AllUrlList" xml:"AllUrlList"`
	Url200List Url200List `json:"Url200List" xml:"Url200List"`
	Url300List Url300List `json:"Url300List" xml:"Url300List"`
	Url400List Url400List `json:"Url400List" xml:"Url400List"`
	Url500List Url500List `json:"Url500List" xml:"Url500List"`
}

// CreateDescribeDcdnDomainTopUrlVisitRequest creates a request to invoke DescribeDcdnDomainTopUrlVisit API
func CreateDescribeDcdnDomainTopUrlVisitRequest() (request *DescribeDcdnDomainTopUrlVisitRequest) {
	request = &DescribeDcdnDomainTopUrlVisitRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainTopUrlVisit", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainTopUrlVisitResponse creates a response to parse from DescribeDcdnDomainTopUrlVisit response
func CreateDescribeDcdnDomainTopUrlVisitResponse() (response *DescribeDcdnDomainTopUrlVisitResponse) {
	response = &DescribeDcdnDomainTopUrlVisitResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
