package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDdosService invokes the dcdn.DescribeDcdnDdosService API synchronously
func (client *Client) DescribeDcdnDdosService(request *DescribeDcdnDdosServiceRequest) (response *DescribeDcdnDdosServiceResponse, err error) {
	response = CreateDescribeDcdnDdosServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDdosServiceWithChan invokes the dcdn.DescribeDcdnDdosService API asynchronously
func (client *Client) DescribeDcdnDdosServiceWithChan(request *DescribeDcdnDdosServiceRequest) (<-chan *DescribeDcdnDdosServiceResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDdosServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDdosService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDdosServiceWithCallback invokes the dcdn.DescribeDcdnDdosService API asynchronously
func (client *Client) DescribeDcdnDdosServiceWithCallback(request *DescribeDcdnDdosServiceRequest, callback func(response *DescribeDcdnDdosServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDdosServiceResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDdosService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDdosServiceRequest is the request struct for api DescribeDcdnDdosService
type DescribeDcdnDdosServiceRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeDcdnDdosServiceResponse is the response struct for api DescribeDcdnDdosService
type DescribeDcdnDdosServiceResponse struct {
	*responses.BaseResponse
	Status             string `json:"Status" xml:"Status"`
	ChangingAffectTime string `json:"ChangingAffectTime" xml:"ChangingAffectTime"`
	OpeningTime        string `json:"OpeningTime" xml:"OpeningTime"`
	ChangingEdition    string `json:"ChangingEdition" xml:"ChangingEdition"`
	ChargeType         string `json:"ChargeType" xml:"ChargeType"`
	DomianNum          int    `json:"DomianNum" xml:"DomianNum"`
	ChangingProtectNum int    `json:"ChangingProtectNum" xml:"ChangingProtectNum"`
	ChangingDomianNum  int    `json:"ChangingDomianNum" xml:"ChangingDomianNum"`
	InstanceId         string `json:"InstanceId" xml:"InstanceId"`
	Edition            string `json:"Edition" xml:"Edition"`
	ChangingChargeType string `json:"ChangingChargeType" xml:"ChangingChargeType"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	ProtectNum         int    `json:"ProtectNum" xml:"ProtectNum"`
	Enabled            string `json:"Enabled" xml:"Enabled"`
	EndingTime         string `json:"EndingTime" xml:"EndingTime"`
}

// CreateDescribeDcdnDdosServiceRequest creates a request to invoke DescribeDcdnDdosService API
func CreateDescribeDcdnDdosServiceRequest() (request *DescribeDcdnDdosServiceRequest) {
	request = &DescribeDcdnDdosServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDdosService", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDdosServiceResponse creates a response to parse from DescribeDcdnDdosService response
func CreateDescribeDcdnDdosServiceResponse() (response *DescribeDcdnDdosServiceResponse) {
	response = &DescribeDcdnDdosServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
