package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgRunSensIdentify invokes the dataworks_public.DsgRunSensIdentify API synchronously
func (client *Client) DsgRunSensIdentify(request *DsgRunSensIdentifyRequest) (response *DsgRunSensIdentifyResponse, err error) {
	response = CreateDsgRunSensIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// DsgRunSensIdentifyWithChan invokes the dataworks_public.DsgRunSensIdentify API asynchronously
func (client *Client) DsgRunSensIdentifyWithChan(request *DsgRunSensIdentifyRequest) (<-chan *DsgRunSensIdentifyResponse, <-chan error) {
	responseChan := make(chan *DsgRunSensIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgRunSensIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgRunSensIdentifyWithCallback invokes the dataworks_public.DsgRunSensIdentify API asynchronously
func (client *Client) DsgRunSensIdentifyWithCallback(request *DsgRunSensIdentifyRequest, callback func(response *DsgRunSensIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgRunSensIdentifyResponse
		var err error
		defer close(result)
		response, err = client.DsgRunSensIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgRunSensIdentifyRequest is the request struct for api DsgRunSensIdentify
type DsgRunSensIdentifyRequest struct {
	*requests.RpcRequest
	TenantId     string                            `position:"Body" name:"TenantId"`
	EsMetaParams *[]DsgRunSensIdentifyEsMetaParams `position:"Body" name:"EsMetaParams"  type:"Json"`
}

// DsgRunSensIdentifyEsMetaParams is a repeated param struct in DsgRunSensIdentifyRequest
type DsgRunSensIdentifyEsMetaParams struct {
	TableNameList *[]string `name:"TableNameList" type:"Repeated"`
	ProjectName   string    `name:"ProjectName"`
	SchemaName    string    `name:"SchemaName"`
	InstanceId    string    `name:"InstanceId"`
	DbType        string    `name:"DbType"`
	ClusterId     string    `name:"ClusterId"`
	TableName     string    `name:"TableName"`
	User          string    `name:"User"`
}

// DsgRunSensIdentifyResponse is the response struct for api DsgRunSensIdentify
type DsgRunSensIdentifyResponse struct {
	*responses.BaseResponse
}

// CreateDsgRunSensIdentifyRequest creates a request to invoke DsgRunSensIdentify API
func CreateDsgRunSensIdentifyRequest() (request *DsgRunSensIdentifyRequest) {
	request = &DsgRunSensIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgRunSensIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgRunSensIdentifyResponse creates a response to parse from DsgRunSensIdentify response
func CreateDsgRunSensIdentifyResponse() (response *DsgRunSensIdentifyResponse) {
	response = &DsgRunSensIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
