package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsyncErrorRequestListByCode invokes the das.GetAsyncErrorRequestListByCode API synchronously
func (client *Client) GetAsyncErrorRequestListByCode(request *GetAsyncErrorRequestListByCodeRequest) (response *GetAsyncErrorRequestListByCodeResponse, err error) {
	response = CreateGetAsyncErrorRequestListByCodeResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsyncErrorRequestListByCodeWithChan invokes the das.GetAsyncErrorRequestListByCode API asynchronously
func (client *Client) GetAsyncErrorRequestListByCodeWithChan(request *GetAsyncErrorRequestListByCodeRequest) (<-chan *GetAsyncErrorRequestListByCodeResponse, <-chan error) {
	responseChan := make(chan *GetAsyncErrorRequestListByCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsyncErrorRequestListByCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsyncErrorRequestListByCodeWithCallback invokes the das.GetAsyncErrorRequestListByCode API asynchronously
func (client *Client) GetAsyncErrorRequestListByCodeWithCallback(request *GetAsyncErrorRequestListByCodeRequest, callback func(response *GetAsyncErrorRequestListByCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsyncErrorRequestListByCodeResponse
		var err error
		defer close(result)
		response, err = client.GetAsyncErrorRequestListByCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsyncErrorRequestListByCodeRequest is the request struct for api GetAsyncErrorRequestListByCode
type GetAsyncErrorRequestListByCodeRequest struct {
	*requests.RpcRequest
	Start      requests.Integer `position:"Query" name:"Start"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	End        requests.Integer `position:"Query" name:"End"`
	NodeId     string           `position:"Query" name:"NodeId"`
	ErrorCode  string           `position:"Query" name:"ErrorCode"`
}

// GetAsyncErrorRequestListByCodeResponse is the response struct for api GetAsyncErrorRequestListByCode
type GetAsyncErrorRequestListByCodeResponse struct {
	*responses.BaseResponse
	Code      int64  `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetAsyncErrorRequestListByCodeRequest creates a request to invoke GetAsyncErrorRequestListByCode API
func CreateGetAsyncErrorRequestListByCodeRequest() (request *GetAsyncErrorRequestListByCodeRequest) {
	request = &GetAsyncErrorRequestListByCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetAsyncErrorRequestListByCode", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAsyncErrorRequestListByCodeResponse creates a response to parse from GetAsyncErrorRequestListByCode response
func CreateGetAsyncErrorRequestListByCodeResponse() (response *GetAsyncErrorRequestListByCodeResponse) {
	response = &GetAsyncErrorRequestListByCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
