package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWmExtractTask invokes the csas.GetWmExtractTask API synchronously
func (client *Client) GetWmExtractTask(request *GetWmExtractTaskRequest) (response *GetWmExtractTaskResponse, err error) {
	response = CreateGetWmExtractTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetWmExtractTaskWithChan invokes the csas.GetWmExtractTask API asynchronously
func (client *Client) GetWmExtractTaskWithChan(request *GetWmExtractTaskRequest) (<-chan *GetWmExtractTaskResponse, <-chan error) {
	responseChan := make(chan *GetWmExtractTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWmExtractTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWmExtractTaskWithCallback invokes the csas.GetWmExtractTask API asynchronously
func (client *Client) GetWmExtractTaskWithCallback(request *GetWmExtractTaskRequest, callback func(response *GetWmExtractTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWmExtractTaskResponse
		var err error
		defer close(result)
		response, err = client.GetWmExtractTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWmExtractTaskRequest is the request struct for api GetWmExtractTask
type GetWmExtractTaskRequest struct {
	*requests.RpcRequest
	ApiType  string `position:"Query" name:"ApiType"`
	SourceIp string `position:"Query" name:"SourceIp"`
	TaskId   string `position:"Query" name:"TaskId"`
}

// GetWmExtractTaskResponse is the response struct for api GetWmExtractTask
type GetWmExtractTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetWmExtractTaskRequest creates a request to invoke GetWmExtractTask API
func CreateGetWmExtractTaskRequest() (request *GetWmExtractTaskRequest) {
	request = &GetWmExtractTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetWmExtractTask", "", "")
	request.Method = requests.GET
	return
}

// CreateGetWmExtractTaskResponse creates a response to parse from GetWmExtractTask response
func CreateGetWmExtractTaskResponse() (response *GetWmExtractTaskResponse) {
	response = &GetWmExtractTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
