package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMaterials invokes the cloudesl.DescribeMaterials API synchronously
func (client *Client) DescribeMaterials(request *DescribeMaterialsRequest) (response *DescribeMaterialsResponse, err error) {
	response = CreateDescribeMaterialsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMaterialsWithChan invokes the cloudesl.DescribeMaterials API asynchronously
func (client *Client) DescribeMaterialsWithChan(request *DescribeMaterialsRequest) (<-chan *DescribeMaterialsResponse, <-chan error) {
	responseChan := make(chan *DescribeMaterialsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMaterials(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMaterialsWithCallback invokes the cloudesl.DescribeMaterials API asynchronously
func (client *Client) DescribeMaterialsWithCallback(request *DescribeMaterialsRequest, callback func(response *DescribeMaterialsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMaterialsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMaterials(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMaterialsRequest is the request struct for api DescribeMaterials
type DescribeMaterialsRequest struct {
	*requests.RpcRequest
	Source     string           `position:"Body" name:"Source"`
	Type       requests.Integer `position:"Body" name:"Type"`
	MaterialId string           `position:"Body" name:"MaterialId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	Size       string           `position:"Body" name:"Size"`
	Name       string           `position:"Body" name:"Name"`
}

// DescribeMaterialsResponse is the response struct for api DescribeMaterials
type DescribeMaterialsResponse struct {
	*responses.BaseResponse
	TotalCount     int        `json:"TotalCount" xml:"TotalCount"`
	PageNumber     int        `json:"PageNumber" xml:"PageNumber"`
	PageSize       int        `json:"PageSize" xml:"PageSize"`
	RequestId      string     `json:"RequestId" xml:"RequestId"`
	Success        bool       `json:"Success" xml:"Success"`
	Message        string     `json:"Message" xml:"Message"`
	ErrorCode      string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string     `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string     `json:"Code" xml:"Code"`
	DynamicCode    string     `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string     `json:"DynamicMessage" xml:"DynamicMessage"`
	Materials      []Material `json:"Materials" xml:"Materials"`
}

// CreateDescribeMaterialsRequest creates a request to invoke DescribeMaterials API
func CreateDescribeMaterialsRequest() (request *DescribeMaterialsRequest) {
	request = &DescribeMaterialsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeMaterials", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMaterialsResponse creates a response to parse from DescribeMaterials response
func CreateDescribeMaterialsResponse() (response *DescribeMaterialsResponse) {
	response = &DescribeMaterialsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
