package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageQueryWhiteListSetting invokes the cloudauth.PageQueryWhiteListSetting API synchronously
func (client *Client) PageQueryWhiteListSetting(request *PageQueryWhiteListSettingRequest) (response *PageQueryWhiteListSettingResponse, err error) {
	response = CreatePageQueryWhiteListSettingResponse()
	err = client.DoAction(request, response)
	return
}

// PageQueryWhiteListSettingWithChan invokes the cloudauth.PageQueryWhiteListSetting API asynchronously
func (client *Client) PageQueryWhiteListSettingWithChan(request *PageQueryWhiteListSettingRequest) (<-chan *PageQueryWhiteListSettingResponse, <-chan error) {
	responseChan := make(chan *PageQueryWhiteListSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageQueryWhiteListSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageQueryWhiteListSettingWithCallback invokes the cloudauth.PageQueryWhiteListSetting API asynchronously
func (client *Client) PageQueryWhiteListSettingWithCallback(request *PageQueryWhiteListSettingRequest, callback func(response *PageQueryWhiteListSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageQueryWhiteListSettingResponse
		var err error
		defer close(result)
		response, err = client.PageQueryWhiteListSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageQueryWhiteListSettingRequest is the request struct for api PageQueryWhiteListSetting
type PageQueryWhiteListSettingRequest struct {
	*requests.RpcRequest
	ValidEndDate   string           `position:"Query" name:"ValidEndDate"`
	CertifyId      string           `position:"Query" name:"CertifyId"`
	CertNo         string           `position:"Query" name:"CertNo"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage    requests.Integer `position:"Query" name:"CurrentPage"`
	ServiceCode    string           `position:"Query" name:"ServiceCode"`
	SceneId        requests.Integer `position:"Query" name:"SceneId"`
	ValidStartDate string           `position:"Query" name:"ValidStartDate"`
	Status         string           `position:"Query" name:"Status"`
}

// PageQueryWhiteListSettingResponse is the response struct for api PageQueryWhiteListSetting
type PageQueryWhiteListSettingResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	Code         string             `json:"Code" xml:"Code"`
	Message      string             `json:"Message" xml:"Message"`
	Success      bool               `json:"Success" xml:"Success"`
	TotalItem    int                `json:"TotalItem" xml:"TotalItem"`
	TotalPage    int                `json:"TotalPage" xml:"TotalPage"`
	CurrentPage  int                `json:"CurrentPage" xml:"CurrentPage"`
	PageSize     int                `json:"PageSize" xml:"PageSize"`
	ResultObject []ResultObjectItem `json:"ResultObject" xml:"ResultObject"`
}

// CreatePageQueryWhiteListSettingRequest creates a request to invoke PageQueryWhiteListSetting API
func CreatePageQueryWhiteListSettingRequest() (request *PageQueryWhiteListSettingRequest) {
	request = &PageQueryWhiteListSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "PageQueryWhiteListSetting", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePageQueryWhiteListSettingResponse creates a response to parse from PageQueryWhiteListSetting response
func CreatePageQueryWhiteListSettingResponse() (response *PageQueryWhiteListSettingResponse) {
	response = &PageQueryWhiteListSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
