package aigen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InteractiveFullSegmentation invokes the aigen.InteractiveFullSegmentation API synchronously
func (client *Client) InteractiveFullSegmentation(request *InteractiveFullSegmentationRequest) (response *InteractiveFullSegmentationResponse, err error) {
	response = CreateInteractiveFullSegmentationResponse()
	err = client.DoAction(request, response)
	return
}

// InteractiveFullSegmentationWithChan invokes the aigen.InteractiveFullSegmentation API asynchronously
func (client *Client) InteractiveFullSegmentationWithChan(request *InteractiveFullSegmentationRequest) (<-chan *InteractiveFullSegmentationResponse, <-chan error) {
	responseChan := make(chan *InteractiveFullSegmentationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InteractiveFullSegmentation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InteractiveFullSegmentationWithCallback invokes the aigen.InteractiveFullSegmentation API asynchronously
func (client *Client) InteractiveFullSegmentationWithCallback(request *InteractiveFullSegmentationRequest, callback func(response *InteractiveFullSegmentationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InteractiveFullSegmentationResponse
		var err error
		defer close(result)
		response, err = client.InteractiveFullSegmentation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InteractiveFullSegmentationRequest is the request struct for api InteractiveFullSegmentation
type InteractiveFullSegmentationRequest struct {
	*requests.RpcRequest
	ReturnFormat string           `position:"Body" name:"ReturnFormat"`
	Async        requests.Boolean `position:"Body" name:"Async"`
	ImageUrl     string           `position:"Body" name:"ImageUrl"`
}

// InteractiveFullSegmentationResponse is the response struct for api InteractiveFullSegmentation
type InteractiveFullSegmentationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateInteractiveFullSegmentationRequest creates a request to invoke InteractiveFullSegmentation API
func CreateInteractiveFullSegmentationRequest() (request *InteractiveFullSegmentationRequest) {
	request = &InteractiveFullSegmentationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aigen", "2024-01-11", "InteractiveFullSegmentation", "", "")
	request.Method = requests.POST
	return
}

// CreateInteractiveFullSegmentationResponse creates a response to parse from InteractiveFullSegmentation response
func CreateInteractiveFullSegmentationResponse() (response *InteractiveFullSegmentationResponse) {
	response = &InteractiveFullSegmentationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
