package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDegradeRule invokes the ahas_openapi.CreateDegradeRule API synchronously
func (client *Client) CreateDegradeRule(request *CreateDegradeRuleRequest) (response *CreateDegradeRuleResponse, err error) {
	response = CreateCreateDegradeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDegradeRuleWithChan invokes the ahas_openapi.CreateDegradeRule API asynchronously
func (client *Client) CreateDegradeRuleWithChan(request *CreateDegradeRuleRequest) (<-chan *CreateDegradeRuleResponse, <-chan error) {
	responseChan := make(chan *CreateDegradeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDegradeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDegradeRuleWithCallback invokes the ahas_openapi.CreateDegradeRule API asynchronously
func (client *Client) CreateDegradeRuleWithCallback(request *CreateDegradeRuleRequest, callback func(response *CreateDegradeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDegradeRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateDegradeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDegradeRuleRequest is the request struct for api CreateDegradeRule
type CreateDegradeRuleRequest struct {
	*requests.RpcRequest
	RecoveryTimeoutMs         requests.Integer `position:"Query" name:"RecoveryTimeoutMs"`
	Threshold                 requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId              string           `position:"Query" name:"AhasRegionId"`
	HalfOpenBaseAmountPerStep requests.Integer `position:"Query" name:"HalfOpenBaseAmountPerStep"`
	AppName                   string           `position:"Query" name:"AppName"`
	Enable                    requests.Boolean `position:"Query" name:"Enable"`
	StatDurationMs            requests.Integer `position:"Query" name:"StatDurationMs"`
	MinRequestAmount          requests.Integer `position:"Query" name:"MinRequestAmount"`
	SlowRtMs                  requests.Integer `position:"Query" name:"SlowRtMs"`
	Resource                  string           `position:"Query" name:"Resource"`
	Namespace                 string           `position:"Query" name:"Namespace"`
	HalfOpenRecoveryStepNum   requests.Integer `position:"Query" name:"HalfOpenRecoveryStepNum"`
	Strategy                  requests.Integer `position:"Query" name:"Strategy"`
}

// CreateDegradeRuleResponse is the response struct for api CreateDegradeRule
type CreateDegradeRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDegradeRuleRequest creates a request to invoke CreateDegradeRule API
func CreateCreateDegradeRuleRequest() (request *CreateDegradeRuleRequest) {
	request = &CreateDegradeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "CreateDegradeRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDegradeRuleResponse creates a response to parse from CreateDegradeRule response
func CreateCreateDegradeRuleResponse() (response *CreateDegradeRuleResponse) {
	response = &CreateDegradeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
