package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecretValues invokes the ververica.ListSecretValues API synchronously
func (client *Client) ListSecretValues(request *ListSecretValuesRequest) (response *ListSecretValuesResponse, err error) {
	response = CreateListSecretValuesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecretValuesWithChan invokes the ververica.ListSecretValues API asynchronously
func (client *Client) ListSecretValuesWithChan(request *ListSecretValuesRequest) (<-chan *ListSecretValuesResponse, <-chan error) {
	responseChan := make(chan *ListSecretValuesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecretValues(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecretValuesWithCallback invokes the ververica.ListSecretValues API asynchronously
func (client *Client) ListSecretValuesWithCallback(request *ListSecretValuesRequest, callback func(response *ListSecretValuesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecretValuesResponse
		var err error
		defer close(result)
		response, err = client.ListSecretValues(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecretValuesRequest is the request struct for api ListSecretValues
type ListSecretValuesRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
}

// ListSecretValuesResponse is the response struct for api ListSecretValues
type ListSecretValuesResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateListSecretValuesRequest creates a request to invoke ListSecretValues API
func CreateListSecretValuesRequest() (request *ListSecretValuesRequest) {
	request = &ListSecretValuesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListSecretValues", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/secret-values", "", "")
	request.Method = requests.GET
	return
}

// CreateListSecretValuesResponse creates a response to parse from ListSecretValues response
func CreateListSecretValuesResponse() (response *ListSecretValuesResponse) {
	response = &ListSecretValuesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
