package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDeployment invokes the ververica.CreateDeployment API synchronously
func (client *Client) CreateDeployment(request *CreateDeploymentRequest) (response *CreateDeploymentResponse, err error) {
	response = CreateCreateDeploymentResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDeploymentWithChan invokes the ververica.CreateDeployment API asynchronously
func (client *Client) CreateDeploymentWithChan(request *CreateDeploymentRequest) (<-chan *CreateDeploymentResponse, <-chan error) {
	responseChan := make(chan *CreateDeploymentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDeployment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDeploymentWithCallback invokes the ververica.CreateDeployment API asynchronously
func (client *Client) CreateDeploymentWithCallback(request *CreateDeploymentRequest, callback func(response *CreateDeploymentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDeploymentResponse
		var err error
		defer close(result)
		response, err = client.CreateDeployment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDeploymentRequest is the request struct for api CreateDeployment
type CreateDeploymentRequest struct {
	*requests.RoaRequest
	Workspace  string `position:"Path" name:"workspace"`
	ParamsJson string `position:"Body" name:"paramsJson"`
	Namespace  string `position:"Path" name:"namespace"`
}

// CreateDeploymentResponse is the response struct for api CreateDeployment
type CreateDeploymentResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
}

// CreateCreateDeploymentRequest creates a request to invoke CreateDeployment API
func CreateCreateDeploymentRequest() (request *CreateDeploymentRequest) {
	request = &CreateDeploymentRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "CreateDeployment", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/deployments", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDeploymentResponse creates a response to parse from CreateDeployment response
func CreateCreateDeploymentResponse() (response *CreateDeploymentResponse) {
	response = &CreateDeploymentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
