package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGatewayLogging invokes the sgw.DeleteGatewayLogging API synchronously
func (client *Client) DeleteGatewayLogging(request *DeleteGatewayLoggingRequest) (response *DeleteGatewayLoggingResponse, err error) {
	response = CreateDeleteGatewayLoggingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGatewayLoggingWithChan invokes the sgw.DeleteGatewayLogging API asynchronously
func (client *Client) DeleteGatewayLoggingWithChan(request *DeleteGatewayLoggingRequest) (<-chan *DeleteGatewayLoggingResponse, <-chan error) {
	responseChan := make(chan *DeleteGatewayLoggingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGatewayLogging(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGatewayLoggingWithCallback invokes the sgw.DeleteGatewayLogging API asynchronously
func (client *Client) DeleteGatewayLoggingWithCallback(request *DeleteGatewayLoggingRequest, callback func(response *DeleteGatewayLoggingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGatewayLoggingResponse
		var err error
		defer close(result)
		response, err = client.DeleteGatewayLogging(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGatewayLoggingRequest is the request struct for api DeleteGatewayLogging
type DeleteGatewayLoggingRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DeleteGatewayLoggingResponse is the response struct for api DeleteGatewayLogging
type DeleteGatewayLoggingResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteGatewayLoggingRequest creates a request to invoke DeleteGatewayLogging API
func CreateDeleteGatewayLoggingRequest() (request *DeleteGatewayLoggingRequest) {
	request = &DeleteGatewayLoggingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DeleteGatewayLogging", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGatewayLoggingResponse creates a response to parse from DeleteGatewayLogging response
func CreateDeleteGatewayLoggingResponse() (response *DeleteGatewayLoggingResponse) {
	response = &DeleteGatewayLoggingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
