package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateGatewayCacheDisk invokes the sgw.CreateGatewayCacheDisk API synchronously
func (client *Client) CreateGatewayCacheDisk(request *CreateGatewayCacheDiskRequest) (response *CreateGatewayCacheDiskResponse, err error) {
	response = CreateCreateGatewayCacheDiskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateGatewayCacheDiskWithChan invokes the sgw.CreateGatewayCacheDisk API asynchronously
func (client *Client) CreateGatewayCacheDiskWithChan(request *CreateGatewayCacheDiskRequest) (<-chan *CreateGatewayCacheDiskResponse, <-chan error) {
	responseChan := make(chan *CreateGatewayCacheDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateGatewayCacheDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateGatewayCacheDiskWithCallback invokes the sgw.CreateGatewayCacheDisk API asynchronously
func (client *Client) CreateGatewayCacheDiskWithCallback(request *CreateGatewayCacheDiskRequest, callback func(response *CreateGatewayCacheDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateGatewayCacheDiskResponse
		var err error
		defer close(result)
		response, err = client.CreateGatewayCacheDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateGatewayCacheDiskRequest is the request struct for api CreateGatewayCacheDisk
type CreateGatewayCacheDiskRequest struct {
	*requests.RpcRequest
	CacheDiskSizeInGB requests.Integer `position:"Query" name:"CacheDiskSizeInGB"`
	SecurityToken     string           `position:"Query" name:"SecurityToken"`
	CacheDiskCategory string           `position:"Query" name:"CacheDiskCategory"`
	GatewayId         string           `position:"Query" name:"GatewayId"`
}

// CreateGatewayCacheDiskResponse is the response struct for api CreateGatewayCacheDisk
type CreateGatewayCacheDiskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
	BuyURL    string `json:"BuyURL" xml:"BuyURL"`
}

// CreateCreateGatewayCacheDiskRequest creates a request to invoke CreateGatewayCacheDisk API
func CreateCreateGatewayCacheDiskRequest() (request *CreateGatewayCacheDiskRequest) {
	request = &CreateGatewayCacheDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateGatewayCacheDisk", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateGatewayCacheDiskResponse creates a response to parse from CreateGatewayCacheDisk response
func CreateCreateGatewayCacheDiskResponse() (response *CreateGatewayCacheDiskResponse) {
	response = &CreateGatewayCacheDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
