package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeCheck invokes the safe.ChangeCheck API synchronously
func (client *Client) ChangeCheck(request *ChangeCheckRequest) (response *ChangeCheckResponse, err error) {
	response = CreateChangeCheckResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeCheckWithChan invokes the safe.ChangeCheck API asynchronously
func (client *Client) ChangeCheckWithChan(request *ChangeCheckRequest) (<-chan *ChangeCheckResponse, <-chan error) {
	responseChan := make(chan *ChangeCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeCheckWithCallback invokes the safe.ChangeCheck API asynchronously
func (client *Client) ChangeCheckWithCallback(request *ChangeCheckRequest, callback func(response *ChangeCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeCheckResponse
		var err error
		defer close(result)
		response, err = client.ChangeCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeCheckRequest is the request struct for api ChangeCheck
type ChangeCheckRequest struct {
	*requests.RpcRequest
	ChangeEnv                string                              `position:"Body" name:"ChangeEnv"`
	AuthKey                  string                              `position:"Body" name:"AuthKey"`
	ChangeOptSubType         string                              `position:"Body" name:"ChangeOptSubType"`
	ReleasePackageInfos      *[]ChangeCheckReleasePackageInfos   `position:"Body" name:"ReleasePackageInfos"  type:"Repeated"`
	Instance                 ChangeCheckInstance                 `position:"Body" name:"Instance"  type:"Struct"`
	ChangeOptType            string                              `position:"Body" name:"ChangeOptType"`
	ChangeDataType           string                              `position:"Body" name:"ChangeDataType"`
	AuthSign                 string                              `position:"Body" name:"AuthSign"`
	DamagedChangeNotices     *[]ChangeCheckDamagedChangeNotices  `position:"Body" name:"DamagedChangeNotices"  type:"Json"`
	InfluenceInfo            ChangeCheckInfluenceInfo            `position:"Body" name:"InfluenceInfo"  type:"Struct"`
	ExtraInfo                string                              `position:"Body" name:"ExtraInfo"`
	ChangeSchemes            string                              `position:"Body" name:"ChangeSchemes"`
	WhiteType                requests.Integer                    `position:"Body" name:"WhiteType"`
	ChangeTimes              *[]ChangeCheckChangeTimes           `position:"Body" name:"ChangeTimes"  type:"Repeated"`
	ReuseSourceOrderId       string                              `position:"Body" name:"ReuseSourceOrderId"`
	ChangeValidation         string                              `position:"Body" name:"ChangeValidation"`
	ChangeEndTime            requests.Integer                    `position:"Body" name:"ChangeEndTime"`
	SourceOrderId            string                              `position:"Body" name:"SourceOrderId"`
	CallBackInfo             ChangeCheckCallBackInfo             `position:"Body" name:"CallBackInfo"  type:"Struct"`
	Rollback                 string                              `position:"Body" name:"Rollback"`
	BlockInfos               *[]ChangeCheckBlockInfos            `position:"Body" name:"BlockInfos"  type:"Repeated"`
	GrayStatus               string                              `position:"Body" name:"GrayStatus"`
	Product                  *[]ChangeCheckProduct               `position:"Body" name:"Product"  type:"Repeated"`
	BgCustomTemplateExtraDTO ChangeCheckBgCustomTemplateExtraDTO `position:"Body" name:"BgCustomTemplateExtraDTO"  type:"Struct"`
	Follower                 *[]string                           `position:"Body" name:"Follower"  type:"Repeated"`
	ChangeObject             string                              `position:"Body" name:"ChangeObject"`
	SourceName               string                              `position:"Body" name:"SourceName"`
	RiskLevel                string                              `position:"Body" name:"RiskLevel"`
	ChangeTitle              string                              `position:"Body" name:"ChangeTitle"`
	NeedModifyDoc            string                              `position:"Body" name:"NeedModifyDoc"`
	CreatorEmpId             string                              `position:"Body" name:"CreatorEmpId"`
	ChangeStartTime          requests.Integer                    `position:"Body" name:"ChangeStartTime"`
	SourceUrl                string                              `position:"Body" name:"SourceUrl"`
	ReqTimestamp             requests.Integer                    `position:"Body" name:"ReqTimestamp"`
	HarmChangeNoticeEnum     string                              `position:"Body" name:"HarmChangeNoticeEnum"`
	ChangeDesc               string                              `position:"Body" name:"ChangeDesc"`
	ExecutorEmpId            string                              `position:"Body" name:"ExecutorEmpId"`
	BgVid                    string                              `position:"Body" name:"BgVid"`
	AffectCustomer           string                              `position:"Body" name:"AffectCustomer"`
	ChangeSubTypeDesc        string                              `position:"Body" name:"ChangeSubTypeDesc"`
	ChangeSystem             string                              `position:"Body" name:"ChangeSystem"`
	Incidence                string                              `position:"Body" name:"Incidence"`
	ApproveFlowParam         ChangeCheckApproveFlowParam         `position:"Body" name:"ApproveFlowParam"  type:"Struct"`
	ChangeReason             string                              `position:"Body" name:"ChangeReason"`
	ChangeRmarks             string                              `position:"Body" name:"ChangeRmarks"`
	ChangeItems              string                              `position:"Body" name:"ChangeItems"`
}

// ChangeCheckDamagedChangeNotices is a repeated param struct in ChangeCheckRequest
type ChangeCheckDamagedChangeNotices struct {
	EventId               string                                                   `name:"EventId"`
	BgCancelNoticeContent string                                                   `name:"BgCancelNoticeContent"`
	Channel               *[]string                                                `name:"Channel" type:"Repeated"`
	Type                  string                                                   `name:"Type"`
	BgCancelNoticeEventId string                                                   `name:"BgCancelNoticeEventId"`
	Content               string                                                   `name:"Content"`
	SensitiveCustomers    *[]ChangeCheckDamagedChangeNoticesSensitiveCustomersItem `name:"SensitiveCustomers" type:"Repeated"`
}

// ChangeCheckDamagedChangeNoticesSensitiveCustomersItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckDamagedChangeNoticesSensitiveCustomersItem struct {
	ProductCode  string                                                                   `name:"ProductCode"`
	CustomerInfo *[]ChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem `name:"CustomerInfo" type:"Repeated"`
}

// ChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckDamagedChangeNoticesSensitiveCustomersItemCustomerInfoItem struct {
	Uid       string            `name:"Uid"`
	Type      string            `name:"Type"`
	ExtraInfo map[string]string `name:"ExtraInfo" type:"Map"`
}

// ChangeCheckReleasePackageInfos is a repeated param struct in ChangeCheckRequest
type ChangeCheckReleasePackageInfos struct {
	ReleasePackage *[]string `name:"ReleasePackage" type:"Repeated"`
	ProductCode    string    `name:"ProductCode"`
}

// ChangeCheckInstance is a repeated param struct in ChangeCheckRequest
type ChangeCheckInstance struct {
	Instance       *[]string `name:"Instance" type:"Repeated"`
	Nc             *[]string `name:"Nc" type:"Repeated"`
	Uids           *[]string `name:"Uids" type:"Repeated"`
	InfluenceApp   *[]string `name:"InfluenceApp" type:"Repeated"`
	AttributionApp *[]string `name:"AttributionApp" type:"Repeated"`
}

// ChangeCheckInfluenceInfo is a repeated param struct in ChangeCheckRequest
type ChangeCheckInfluenceInfo struct {
	NoticeInfos        *[]ChangeCheckInfluenceInfoNoticeInfosItem        `name:"NoticeInfos" type:"Repeated"`
	SensitiveCustomers *[]ChangeCheckInfluenceInfoSensitiveCustomersItem `name:"SensitiveCustomers" type:"Repeated"`
}

// ChangeCheckChangeTimes is a repeated param struct in ChangeCheckRequest
type ChangeCheckChangeTimes struct {
	ChangeEndTime   string `name:"ChangeEndTime"`
	ChangeStartTime string `name:"ChangeStartTime"`
}

// ChangeCheckCallBackInfo is a repeated param struct in ChangeCheckRequest
type ChangeCheckCallBackInfo struct {
	PopProduct string `name:"PopProduct"`
	EndPoint   string `name:"EndPoint"`
	RegionId   string `name:"RegionId"`
	ApiVersion string `name:"ApiVersion"`
	Api        string `name:"Api"`
	Type       string `name:"Type"`
	Url        string `name:"Url"`
	ExtraInfo  string `name:"ExtraInfo"`
}

// ChangeCheckBlockInfos is a repeated param struct in ChangeCheckRequest
type ChangeCheckBlockInfos struct {
	HitInfos *[]ChangeCheckBlockInfosHitInfos `name:"HitInfos" type:"Repeated"`
	Id       string                           `name:"Id"`
}

// ChangeCheckProduct is a repeated param struct in ChangeCheckRequest
type ChangeCheckProduct struct {
	Code string `name:"Code"`
	Name string `name:"Name"`
}

// ChangeCheckBgCustomTemplateExtraDTO is a repeated param struct in ChangeCheckRequest
type ChangeCheckBgCustomTemplateExtraDTO struct {
	BgCustomTemplateTitle string `name:"BgCustomTemplateTitle"`
	BgVid                 string `name:"BgVid"`
	BgCustomTemplateId    string `name:"BgCustomTemplateId"`
	BgCustomTemplate      string `name:"BgCustomTemplate"`
	BgCustomTemplateInfo  string `name:"BgCustomTemplateInfo"`
	ExtraInfo             string `name:"ExtraInfo"`
}

// ChangeCheckApproveFlowParam is a repeated param struct in ChangeCheckRequest
type ChangeCheckApproveFlowParam struct {
	AuthKey      string                                         `name:"AuthKey"`
	ApproveNodes *[]ChangeCheckApproveFlowParamApproveNodesItem `name:"ApproveNodes" type:"Repeated"`
	FlowStatus   string                                         `name:"FlowStatus"`
	BgVid        string                                         `name:"BgVid"`
	AuthSign     string                                         `name:"AuthSign"`
	Timestamp    string                                         `name:"Timestamp"`
}

// ChangeCheckInfluenceInfoNoticeInfosItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckInfluenceInfoNoticeInfosItem struct {
	EventId string    `name:"EventId"`
	Channel *[]string `name:"Channel" type:"Repeated"`
	Content string    `name:"Content"`
}

// ChangeCheckInfluenceInfoSensitiveCustomersItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckInfluenceInfoSensitiveCustomersItem struct {
	ProductCode  string                                                            `name:"ProductCode"`
	CustomerInfo *[]ChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem `name:"CustomerInfo" type:"Repeated"`
}

// ChangeCheckBlockInfosHitInfos is a repeated param struct in ChangeCheckRequest
type ChangeCheckBlockInfosHitInfos struct {
	Scope     string `name:"Scope"`
	HitObject string `name:"HitObject"`
	HitInfo   string `name:"HitInfo"`
}

// ChangeCheckApproveFlowParamApproveNodesItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckApproveFlowParamApproveNodesItem struct {
	ProcessName      string                                                        `name:"ProcessName"`
	NodeStatus       string                                                        `name:"NodeStatus"`
	ApproverDTO      *[]ChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem `name:"ApproverDTO" type:"Repeated"`
	Strategy         string                                                        `name:"Strategy"`
	ProcessNodeOrder string                                                        `name:"ProcessNodeOrder"`
}

// ChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckInfluenceInfoSensitiveCustomersItemCustomerInfoItem struct {
	Uid       string            `name:"Uid"`
	Type      string            `name:"Type"`
	ExtraInfo map[string]string `name:"ExtraInfo" type:"Map"`
}

// ChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem is a repeated param struct in ChangeCheckRequest
type ChangeCheckApproveFlowParamApproveNodesItemApproverDTOItem struct {
	ApproveDesc  string `name:"ApproveDesc"`
	ApproverId   string `name:"ApproverId"`
	ApproverName string `name:"ApproverName"`
	ApproveTime  string `name:"ApproveTime"`
	Opinion      string `name:"Opinion"`
}

// ChangeCheckResponse is the response struct for api ChangeCheck
type ChangeCheckResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateChangeCheckRequest creates a request to invoke ChangeCheck API
func CreateChangeCheckRequest() (request *ChangeCheckRequest) {
	request = &ChangeCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "ChangeCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateChangeCheckResponse creates a response to parse from ChangeCheck response
func CreateChangeCheckResponse() (response *ChangeCheckResponse) {
	response = &ChangeCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
