package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoveResources invokes the resourcemanager.MoveResources API synchronously
func (client *Client) MoveResources(request *MoveResourcesRequest) (response *MoveResourcesResponse, err error) {
	response = CreateMoveResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// MoveResourcesWithChan invokes the resourcemanager.MoveResources API asynchronously
func (client *Client) MoveResourcesWithChan(request *MoveResourcesRequest) (<-chan *MoveResourcesResponse, <-chan error) {
	responseChan := make(chan *MoveResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoveResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoveResourcesWithCallback invokes the resourcemanager.MoveResources API asynchronously
func (client *Client) MoveResourcesWithCallback(request *MoveResourcesRequest, callback func(response *MoveResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoveResourcesResponse
		var err error
		defer close(result)
		response, err = client.MoveResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoveResourcesRequest is the request struct for api MoveResources
type MoveResourcesRequest struct {
	*requests.RpcRequest
	Resources       *[]MoveResourcesResources `position:"Query" name:"Resources"  type:"Repeated"`
	ResourceGroupId string                    `position:"Query" name:"ResourceGroupId"`
}

// MoveResourcesResources is a repeated param struct in MoveResourcesRequest
type MoveResourcesResources struct {
	ResourceId   string `name:"ResourceId"`
	RegionId     string `name:"RegionId"`
	Service      string `name:"Service"`
	ResourceType string `name:"ResourceType"`
}

// MoveResourcesResponse is the response struct for api MoveResources
type MoveResourcesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Responses []Response `json:"Responses" xml:"Responses"`
}

// CreateMoveResourcesRequest creates a request to invoke MoveResources API
func CreateMoveResourcesRequest() (request *MoveResourcesRequest) {
	request = &MoveResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "MoveResources", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMoveResourcesResponse creates a response to parse from MoveResources response
func CreateMoveResourcesResponse() (response *MoveResourcesResponse) {
	response = &MoveResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
