package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PullTryOnShoesEvent invokes the reid.PullTryOnShoesEvent API synchronously
// api document: https://help.aliyun.com/api/reid/pulltryonshoesevent.html
func (client *Client) PullTryOnShoesEvent(request *PullTryOnShoesEventRequest) (response *PullTryOnShoesEventResponse, err error) {
	response = CreatePullTryOnShoesEventResponse()
	err = client.DoAction(request, response)
	return
}

// PullTryOnShoesEventWithChan invokes the reid.PullTryOnShoesEvent API asynchronously
// api document: https://help.aliyun.com/api/reid/pulltryonshoesevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PullTryOnShoesEventWithChan(request *PullTryOnShoesEventRequest) (<-chan *PullTryOnShoesEventResponse, <-chan error) {
	responseChan := make(chan *PullTryOnShoesEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PullTryOnShoesEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PullTryOnShoesEventWithCallback invokes the reid.PullTryOnShoesEvent API asynchronously
// api document: https://help.aliyun.com/api/reid/pulltryonshoesevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PullTryOnShoesEventWithCallback(request *PullTryOnShoesEventRequest, callback func(response *PullTryOnShoesEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PullTryOnShoesEventResponse
		var err error
		defer close(result)
		response, err = client.PullTryOnShoesEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PullTryOnShoesEventRequest is the request struct for api PullTryOnShoesEvent
type PullTryOnShoesEventRequest struct {
	*requests.RpcRequest
	Date       string           `position:"Body" name:"Date"`
	StoreId    requests.Integer `position:"Body" name:"StoreId"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	Name       string           `position:"Body" name:"Name"`
	SkuId      string           `position:"Body" name:"SkuId"`
}

// PullTryOnShoesEventResponse is the response struct for api PullTryOnShoesEvent
type PullTryOnShoesEventResponse struct {
	*responses.BaseResponse
	StoreId              int64  `json:"StoreId" xml:"StoreId"`
	RequestId            string `json:"RequestId" xml:"RequestId"`
	Success              bool   `json:"Success" xml:"Success"`
	StartTs              int64  `json:"StartTs" xml:"StartTs"`
	DynamicMessage       string `json:"DynamicMessage" xml:"DynamicMessage"`
	ErrorCode            string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage         string `json:"ErrorMessage" xml:"ErrorMessage"`
	TryOnShoesEventCount int    `json:"TryOnShoesEventCount" xml:"TryOnShoesEventCount"`
	PageNumber           int    `json:"PageNumber" xml:"PageNumber"`
	Message              string `json:"Message" xml:"Message"`
	Code                 string `json:"Code" xml:"Code"`
	TotalCount           int64  `json:"TotalCount" xml:"TotalCount"`
	DynamicCode          string `json:"DynamicCode" xml:"DynamicCode"`
	SkuId                string `json:"SkuId" xml:"SkuId"`
	PageSize             int    `json:"PageSize" xml:"PageSize"`
}

// CreatePullTryOnShoesEventRequest creates a request to invoke PullTryOnShoesEvent API
func CreatePullTryOnShoesEventRequest() (request *PullTryOnShoesEventRequest) {
	request = &PullTryOnShoesEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "PullTryOnShoesEvent", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePullTryOnShoesEventResponse creates a response to parse from PullTryOnShoesEvent response
func CreatePullTryOnShoesEventResponse() (response *PullTryOnShoesEventResponse) {
	response = &PullTryOnShoesEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
