package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateQuotaApplication invokes the quotas.CreateQuotaApplication API synchronously
func (client *Client) CreateQuotaApplication(request *CreateQuotaApplicationRequest) (response *CreateQuotaApplicationResponse, err error) {
	response = CreateCreateQuotaApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateQuotaApplicationWithChan invokes the quotas.CreateQuotaApplication API asynchronously
func (client *Client) CreateQuotaApplicationWithChan(request *CreateQuotaApplicationRequest) (<-chan *CreateQuotaApplicationResponse, <-chan error) {
	responseChan := make(chan *CreateQuotaApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateQuotaApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateQuotaApplicationWithCallback invokes the quotas.CreateQuotaApplication API asynchronously
func (client *Client) CreateQuotaApplicationWithCallback(request *CreateQuotaApplicationRequest, callback func(response *CreateQuotaApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateQuotaApplicationResponse
		var err error
		defer close(result)
		response, err = client.CreateQuotaApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateQuotaApplicationRequest is the request struct for api CreateQuotaApplication
type CreateQuotaApplicationRequest struct {
	*requests.RpcRequest
	Reason          string                              `position:"Body" name:"Reason"`
	ProductCode     string                              `position:"Body" name:"ProductCode"`
	QuotaActionCode string                              `position:"Body" name:"QuotaActionCode"`
	DesireValue     requests.Float                      `position:"Body" name:"DesireValue"`
	EffectiveTime   string                              `position:"Body" name:"EffectiveTime"`
	QuotaCategory   string                              `position:"Body" name:"QuotaCategory"`
	OriginalContext string                              `position:"Body" name:"OriginalContext"`
	ExpireTime      string                              `position:"Body" name:"ExpireTime"`
	EnvLanguage     string                              `position:"Body" name:"EnvLanguage"`
	NoticeType      requests.Integer                    `position:"Body" name:"NoticeType"`
	AuditMode       string                              `position:"Body" name:"AuditMode"`
	Dimensions      *[]CreateQuotaApplicationDimensions `position:"Body" name:"Dimensions"  type:"Repeated"`
}

// CreateQuotaApplicationDimensions is a repeated param struct in CreateQuotaApplicationRequest
type CreateQuotaApplicationDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateQuotaApplicationResponse is the response struct for api CreateQuotaApplication
type CreateQuotaApplicationResponse struct {
	*responses.BaseResponse
	RequestId        string                 `json:"RequestId" xml:"RequestId"`
	Status           string                 `json:"Status" xml:"Status"`
	DesireValue      int                    `json:"DesireValue" xml:"DesireValue"`
	QuotaActionCode  string                 `json:"QuotaActionCode" xml:"QuotaActionCode"`
	QuotaName        string                 `json:"QuotaName" xml:"QuotaName"`
	ApplicationId    string                 `json:"ApplicationId" xml:"ApplicationId"`
	Reason           string                 `json:"Reason" xml:"Reason"`
	AuditReason      string                 `json:"AuditReason" xml:"AuditReason"`
	QuotaDescription string                 `json:"QuotaDescription" xml:"QuotaDescription"`
	ProductCode      string                 `json:"ProductCode" xml:"ProductCode"`
	QuotaArn         string                 `json:"QuotaArn" xml:"QuotaArn"`
	ApplyTime        string                 `json:"ApplyTime" xml:"ApplyTime"`
	ApproveValue     float64                `json:"ApproveValue" xml:"ApproveValue"`
	Dimension        map[string]interface{} `json:"Dimension" xml:"Dimension"`
	NoticeType       int64                  `json:"NoticeType" xml:"NoticeType"`
	EffectiveTime    string                 `json:"EffectiveTime" xml:"EffectiveTime"`
	ExpireTime       string                 `json:"ExpireTime" xml:"ExpireTime"`
	QuotaUnit        string                 `json:"QuotaUnit" xml:"QuotaUnit"`
}

// CreateCreateQuotaApplicationRequest creates a request to invoke CreateQuotaApplication API
func CreateCreateQuotaApplicationRequest() (request *CreateQuotaApplicationRequest) {
	request = &CreateQuotaApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "CreateQuotaApplication", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateQuotaApplicationResponse creates a response to parse from CreateQuotaApplication response
func CreateCreateQuotaApplicationResponse() (response *CreateQuotaApplicationResponse) {
	response = &CreateQuotaApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
