package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadAudioData invokes the qualitycheck.UploadAudioData API synchronously
func (client *Client) UploadAudioData(request *UploadAudioDataRequest) (response *UploadAudioDataResponse, err error) {
	response = CreateUploadAudioDataResponse()
	err = client.DoAction(request, response)
	return
}

// UploadAudioDataWithChan invokes the qualitycheck.UploadAudioData API asynchronously
func (client *Client) UploadAudioDataWithChan(request *UploadAudioDataRequest) (<-chan *UploadAudioDataResponse, <-chan error) {
	responseChan := make(chan *UploadAudioDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadAudioData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadAudioDataWithCallback invokes the qualitycheck.UploadAudioData API asynchronously
func (client *Client) UploadAudioDataWithCallback(request *UploadAudioDataRequest, callback func(response *UploadAudioDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadAudioDataResponse
		var err error
		defer close(result)
		response, err = client.UploadAudioData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadAudioDataRequest is the request struct for api UploadAudioData
type UploadAudioDataRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	JsonStr         string           `position:"Query" name:"JsonStr"`
	BaseMeAgentId   requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UploadAudioDataResponse is the response struct for api UploadAudioData
type UploadAudioDataResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUploadAudioDataRequest creates a request to invoke UploadAudioData API
func CreateUploadAudioDataRequest() (request *UploadAudioDataRequest) {
	request = &UploadAudioDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UploadAudioData", "", "")
	request.Method = requests.POST
	return
}

// CreateUploadAudioDataResponse creates a response to parse from UploadAudioData response
func CreateUploadAudioDataResponse() (response *UploadAudioDataResponse) {
	response = &UploadAudioDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
